/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io.resolver;

import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.io.Resource;
import io.basc.framework.io.WritableResource;
import io.basc.framework.io.resolver.DefaultPropertiesResolver;
import io.basc.framework.io.resolver.PropertiesResolver;
import io.basc.framework.lang.UnsupportedException;
import java.nio.charset.Charset;
import java.util.Properties;

public class PropertiesResolvers
extends ConfigurableServices<PropertiesResolver>
implements PropertiesResolver {
    public PropertiesResolvers() {
        super(PropertiesResolver.class);
        this.setAfterService(DefaultPropertiesResolver.INSTANCE);
    }

    @Override
    public boolean canResolveProperties(Resource resource) {
        for (PropertiesResolver resolver : this) {
            if (!resolver.canResolveProperties(resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resolveProperties(Properties properties, Resource resource, Charset charset) {
        if (resource == null || !resource.exists()) {
            return;
        }
        for (PropertiesResolver resolver : this) {
            if (!resolver.canResolveProperties(resource)) continue;
            resolver.resolveProperties(properties, resource, charset);
            return;
        }
        throw new UnsupportedException(resource.getDescription());
    }

    @Override
    public void persistenceProperties(Properties properties, WritableResource resource, Charset charset) {
        if (resource == null || !resource.exists()) {
            return;
        }
        for (PropertiesResolver resolver : this) {
            if (!resolver.canResolveProperties(resource)) continue;
            resolver.persistenceProperties(properties, resource, charset);
            return;
        }
        throw new UnsupportedException(resource.getDescription());
    }
}

