/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io.support;

import io.basc.framework.io.FileUtils;
import io.basc.framework.lang.AlreadyExistsException;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Assert;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.comparator.CompareUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class LocalLogger {
    private static Logger logger = LoggerFactory.getLogger(LocalLogger.class);
    private final String directory;

    public LocalLogger(String directory) {
        this.directory = Assert.secureFilePathArgument(directory, "directory");
        File file = new File(directory);
        if (!file.exists()) {
            file.mkdirs();
        }
        logger.info("using local logger: {}", this.directory);
    }

    public String getDirectory() {
        return this.directory;
    }

    private File getFile(String key) {
        return new File(this.directory, Assert.secureFilePathArgument(key, "key"));
    }

    public Record<byte[]> create(String id, byte[] data) throws IOException {
        File file = this.getFile(id);
        if (file.exists()) {
            throw new AlreadyExistsException(file.getPath());
        }
        if (!file.createNewFile()) {
            throw new RuntimeException("create error:" + file.getPath());
        }
        FileUtils.writeByteArrayToFile(file, data);
        return new Record<byte[]>(id, data);
    }

    public boolean delete(String key) {
        File file = this.getFile(key);
        return file.delete();
    }

    private String getKey(File file) {
        String key = file.getPath();
        key = StringUtils.cleanPath(key);
        Assert.isTrue(key.startsWith(this.directory));
        key = key.substring(this.directory.length());
        return key.startsWith("/") ? key.substring(1) : key;
    }

    public boolean isExist(String key) {
        File file = this.getFile(key);
        return file.exists() && file.isFile();
    }

    private List<File> getFileList(String directory) {
        ArrayList<File> list = new ArrayList<File>();
        File rootFile = new File(directory);
        if (rootFile.exists()) {
            File[] files;
            for (File file : files = rootFile.listFiles()) {
                if (file.isFile()) {
                    list.add(file);
                    continue;
                }
                list.addAll(this.getFileList(file.getPath()));
            }
        }
        list.sort(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return CompareUtils.compare(o1.lastModified(), o2.lastModified(), false);
            }
        });
        return list;
    }

    public Enumeration<Record<byte[]>> enumeration() {
        return new RecordEnumeration();
    }

    public static final class Record<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String id;
        private final T data;

        public Record(String id, T data) {
            this.id = id;
            this.data = data;
        }

        public String getId() {
            return this.id;
        }

        public T getData() {
            return this.data;
        }
    }

    private final class RecordEnumeration
    implements Enumeration<Record<byte[]>> {
        private Iterator<File> fileIterator;
        private Record<byte[]> record;
        private boolean next;

        private RecordEnumeration() {
            this.fileIterator = LocalLogger.this.getFileList(LocalLogger.this.directory).iterator();
            this.next = false;
        }

        private Record<byte[]> toRecord(File file) {
            byte[] data = null;
            try {
                data = FileUtils.readFileToByteArray(file);
            }
            catch (IOException e) {
                logger.error(e, "read file error: {}", file.getPath());
            }
            if (data == null) {
                return null;
            }
            return new Record<byte[]>(LocalLogger.this.getKey(file), data);
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next) {
                return true;
            }
            while (this.fileIterator.hasNext()) {
                Record<byte[]> record = this.toRecord(this.fileIterator.next());
                if (record == null) continue;
                this.record = record;
                this.next = true;
                return true;
            }
            return false;
        }

        @Override
        public Record<byte[]> nextElement() {
            if (this.next) {
                this.next = false;
                return this.record;
            }
            while (this.fileIterator.hasNext()) {
                Record<byte[]> record = this.toRecord(this.fileIterator.next());
                if (record == null) continue;
                return record;
            }
            throw new NoSuchElementException();
        }
    }
}

