/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.json;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.json.Json;
import io.basc.framework.json.JsonElement;
import io.basc.framework.json.JsonObject;
import io.basc.framework.util.Processor;
import io.basc.framework.util.XUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public interface JsonArray
extends Json<Integer>,
Iterable<JsonElement> {
    public static final String PREFIX = "[";
    public static final String SUFFIX = "]";

    @Override
    public JsonElement get(Integer var1);

    public boolean add(Object var1);

    public boolean remove(int var1);

    default public Stream<JsonElement> stream() {
        return XUtils.stream(this.iterator());
    }

    default public <T, E extends Throwable> List<T> convert(Processor<JsonElement, T, E> converter) throws E {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(this.size());
        for (JsonElement jsonElement : this) {
            list.add(converter.process(jsonElement));
        }
        return list;
    }

    default public <T> List<T> convert(Class<? extends T> type) {
        return this.convert((JsonElement o) -> {
            Constructor constructor = null;
            if (o.isJsonArray()) {
                constructor = ReflectionUtils.getDeclaredConstructor(type, JsonArray.class);
            } else if (o.isJsonObject()) {
                constructor = ReflectionUtils.getDeclaredConstructor(type, JsonObject.class);
            }
            if (constructor != null) {
                return ReflectionUtils.newInstance(constructor, o.isJsonArray() ? o.getAsJsonArray() : o.getAsJsonObject());
            }
            return o.getAsObject(type);
        });
    }

    default public <T> List<T> convert(Type type) {
        if (type instanceof Class) {
            return this.convert((Class)type);
        }
        return this.convert((JsonElement o) -> o.getAsObject(type));
    }
}

