/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.json;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.support.CharsetCodec;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.io.CrossLanguageSerializer;
import io.basc.framework.io.IOUtils;
import io.basc.framework.json.JsonSupport;
import io.basc.framework.json.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JsonSerializer
implements CrossLanguageSerializer {
    public static final CrossLanguageSerializer INSTANCE = new JsonSerializer();
    private JsonSupport jsonSupport;
    private Codec<String, byte[]> codec = CharsetCodec.UTF_8;

    public JsonSupport getJsonSupport() {
        return this.jsonSupport == null ? JsonUtils.getSupport() : this.jsonSupport;
    }

    public void setJsonSupport(JsonSupport jsonSupport) {
        this.jsonSupport = jsonSupport;
    }

    public Codec<String, byte[]> getCodec() {
        return this.codec;
    }

    public void setCodec(Codec<String, byte[]> codec) {
        this.codec = codec;
    }

    @Override
    public void serialize(Object source, TypeDescriptor sourceTypeDescriptor, OutputStream target) throws IOException {
        String content = this.getJsonSupport().toJsonString(source);
        target.write((byte[])this.codec.encode(content));
    }

    @Override
    public <T> T deserialize(InputStream input, TypeDescriptor type) throws IOException {
        byte[] data = IOUtils.toByteArray(input);
        String content = (String)this.codec.decode((byte[])((String)data));
        return this.getJsonSupport().parseObject(content, type.getResolvableType().getType());
    }
}

