/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.json;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.io.IOUtils;
import io.basc.framework.json.JsonArray;
import io.basc.framework.json.JsonElement;
import io.basc.framework.json.JsonException;
import io.basc.framework.json.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public interface JsonSupport
extends ConversionService {
    public String toJsonString(Object var1) throws JsonException;

    public JsonElement parseJson(String var1) throws JsonException;

    default public JsonArray parseArray(String text) throws JsonException {
        JsonElement jsonElement = this.parseJson(text);
        return jsonElement == null ? null : jsonElement.getAsJsonArray();
    }

    default public JsonObject parseObject(String text) throws JsonException {
        JsonElement jsonElement = this.parseJson(text);
        return jsonElement == null ? null : jsonElement.getAsJsonObject();
    }

    default public JsonElement parseJson(Object obj) throws JsonException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Reader) {
            try {
                return this.parseJson((Reader)obj);
            }
            catch (IOException e) {
                throw new JsonException(obj.toString(), e);
            }
        }
        if (obj instanceof String) {
            return this.parseJson((String)obj);
        }
        return this.parseJson(this.toJsonString(obj));
    }

    default public <T> T parseObject(String text, Class<T> type) throws JsonException {
        if (type == JsonObject.class) {
            return (T)this.parseObject(text);
        }
        if (type == JsonArray.class) {
            return (T)this.parseArray(text);
        }
        if (type == JsonElement.class) {
            return (T)this.parseJson(text);
        }
        if (type == String.class) {
            return (T)text;
        }
        JsonElement jsonElement = this.parseJson(text);
        return jsonElement == null ? null : (T)jsonElement.getAsObject(type);
    }

    default public <T> T parseObject(String text, Type type) throws JsonException {
        if (type instanceof Class) {
            return this.parseObject(text, (Class)type);
        }
        JsonElement jsonElement = this.parseJson(text);
        if (jsonElement == null) {
            return null;
        }
        return (T)jsonElement.getAsObject(type);
    }

    default public JsonArray parseArray(Reader reader) throws IOException, JsonException {
        JsonElement jsonElement = this.parseJson(reader);
        return jsonElement == null ? null : jsonElement.getAsJsonArray();
    }

    default public JsonObject parseObject(Reader reader) throws IOException, JsonException {
        JsonElement jsonElement = this.parseJson(reader);
        return jsonElement == null ? null : jsonElement.getAsJsonObject();
    }

    default public JsonElement parseJson(Reader reader) throws IOException, JsonException {
        return this.parseJson(new String(IOUtils.toCharArray(reader)));
    }

    default public <T> T parseObject(Reader reader, Class<T> type) throws IOException, JsonException {
        if (type == JsonObject.class) {
            return (T)this.parseObject(reader);
        }
        if (type == JsonArray.class) {
            return (T)this.parseArray(reader);
        }
        if (type == JsonElement.class) {
            return (T)this.parseJson(reader);
        }
        return this.parseObject(new String(IOUtils.toCharArray(reader)), type);
    }

    default public <T> T parseObject(Reader reader, Type type) throws IOException, JsonException {
        if (type instanceof Class) {
            return this.parseObject(reader, (Class)type);
        }
        return this.parseObject(new String(IOUtils.toCharArray(reader)), type);
    }

    @Override
    default public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return true;
    }

    @Override
    default public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) throws JsonException {
        JsonElement jsonElement = this.parseJson(source);
        return jsonElement == null ? null : jsonElement.getAsObject(targetType);
    }
}

