/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.locks;

import io.basc.framework.env.Sys;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public abstract class AbstractLock
implements Lock {
    private static final long DEFAULT_SLEEP_TIME = Sys.getEnv().getProperties().get("lock.sleep.time").as(Long.class).orElse(1L);
    private long sleepTime = DEFAULT_SLEEP_TIME;

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    @Override
    public boolean tryLock(long period, TimeUnit timeUnit) throws InterruptedException {
        boolean b = false;
        while (!(b = this.tryLock())) {
            timeUnit.sleep(period);
        }
        return b;
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        while (!this.tryLock()) {
            TimeUnit.MILLISECONDS.sleep(this.sleepTime);
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }
}

