/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.locks;

import io.basc.framework.locks.AbstractLock;
import io.basc.framework.util.Assert;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class RenewableLock
extends AbstractLock {
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private AtomicBoolean autoRenewal = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> scheduledFuture;
    private final TimeUnit timeUnit;
    private final long timeout;

    public RenewableLock(TimeUnit timeUnit, long timeout) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public final TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public long getTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeout, this.timeUnit);
    }

    public boolean autoRenewal() {
        return this.autoRenewal(this.getTimeout(TimeUnit.MILLISECONDS) / 2L, TimeUnit.MILLISECONDS);
    }

    public boolean autoRenewal(long period, TimeUnit timeUnit) {
        Assert.requiredArgument(period > 0L, "period");
        if (this.autoRenewal.get()) {
            return false;
        }
        if (this.autoRenewal.compareAndSet(false, true)) {
            this.scheduledFuture = SCHEDULED_EXECUTOR_SERVICE.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!RenewableLock.this.renewal()) {
                        RenewableLock.this.cancelAutoRenewal();
                    }
                }
            }, period, period, timeUnit);
            return true;
        }
        return false;
    }

    public boolean cancelAutoRenewal() {
        if (!this.autoRenewal.get()) {
            return false;
        }
        if (this.autoRenewal.compareAndSet(true, false)) {
            this.scheduledFuture.cancel(true);
            return true;
        }
        return false;
    }

    public boolean renewal() {
        return this.renewal(this.timeout, this.timeUnit);
    }

    public abstract boolean renewal(long var1, TimeUnit var3);

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SCHEDULED_EXECUTOR_SERVICE.shutdownNow();
                super.run();
            }
        });
    }
}

