/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.logger;

import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.event.support.StandardBroadcastEventDispatcher;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.logger.DynamicLogger;
import io.basc.framework.logger.ILoggerFactory;
import io.basc.framework.logger.JdkLoggerFactory;
import io.basc.framework.logger.LevelManager;
import io.basc.framework.logger.Logger;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Registration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class DynamicLoggerFactory
extends StandardBroadcastEventDispatcher<LevelManager>
implements ILoggerFactory,
Configurable {
    public static final JdkLoggerFactory GLOBA_LOGGER_FACTORY = new JdkLoggerFactory();
    public static final LevelManager GLOBAL_LEVEL_MANAGER = new LevelManager();
    private AtomicBoolean configured = new AtomicBoolean();
    private LevelManager levelManager = GLOBAL_LEVEL_MANAGER;
    private final DynamicLogger logger;
    private ILoggerFactory loggerFactory = GLOBA_LOGGER_FACTORY;
    private volatile Map<String, DynamicLogger> loggerMap = new HashMap<String, DynamicLogger>();
    private Registration registration = this.levelManager.registerListener((ObservableChangeEvent<T> e) -> this.publishEvent(this.levelManager));

    public DynamicLoggerFactory() {
        this.logger = this.getLogger(DynamicLoggerFactory.class.getName());
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        if (this.isConfigured()) {
            return;
        }
        ILoggerFactory loggerFactory = null;
        try {
            loggerFactory = (ILoggerFactory)serviceLoaderFactory.getServiceLoader(ILoggerFactory.class).first();
        }
        catch (Throwable e) {
            this.logger.debug(e, "Configuration log factory exception");
            return;
        }
        if (this.configured.compareAndSet(false, true) && loggerFactory != null) {
            this.setLoggerFactory(loggerFactory);
        }
    }

    public ILoggerFactory getILoggerFactory() {
        return this.loggerFactory;
    }

    public LevelManager getLevelManager() {
        return this.levelManager;
    }

    public DynamicLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicLogger getLogger(String name) {
        DynamicLogger logger = this.loggerMap.get(name);
        if (logger == null) {
            DynamicLoggerFactory dynamicLoggerFactory = this;
            synchronized (dynamicLoggerFactory) {
                logger = this.loggerMap.get(name);
                if (logger == null) {
                    Logger source = this.loggerFactory.getLogger(name);
                    logger = source instanceof DynamicLogger ? (DynamicLogger)source : new DynamicLogger(source);
                    Level level = this.levelManager.getLevel(name);
                    if (level != null) {
                        logger.setLevel(level);
                    }
                    this.registerListener(logger);
                    this.loggerMap.put(name, logger);
                }
            }
        }
        return logger;
    }

    public ILoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public boolean isConfigured() {
        return this.configured.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelManager setLevelManager(LevelManager levelManager) {
        Assert.requiredArgument(levelManager != null, "levelManager");
        if (levelManager == this.levelManager) {
            return this.levelManager;
        }
        DynamicLoggerFactory dynamicLoggerFactory = this;
        synchronized (dynamicLoggerFactory) {
            LevelManager old = this.levelManager;
            this.levelManager = levelManager;
            this.registration.unregister();
            this.registration = levelManager.registerListener((ObservableChangeEvent<T> e) -> this.publishEvent(levelManager));
            this.publishEvent(levelManager);
            this.logger.info("Set level manager [" + levelManager + "]");
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILoggerFactory setLoggerFactory(ILoggerFactory loggerFactory) {
        Assert.requiredArgument(loggerFactory != null, "loggerFactory");
        if (loggerFactory == this.loggerFactory) {
            return this.loggerFactory;
        }
        DynamicLoggerFactory dynamicLoggerFactory = this;
        synchronized (dynamicLoggerFactory) {
            ILoggerFactory old = this.loggerFactory;
            this.loggerFactory = loggerFactory;
            this.logger.setSource(loggerFactory.getLogger(this.logger.getName()));
            this.logger.info("Set logger factory [" + loggerFactory + "]");
            for (Map.Entry<String, DynamicLogger> entry : this.loggerMap.entrySet()) {
                if (entry.getValue() == this.logger) continue;
                String name = entry.getKey();
                Logger oldLogger = entry.getValue().getSource();
                Logger logger = loggerFactory.getLogger(name);
                entry.getValue().setSource(logger);
                try {
                    if (!(oldLogger instanceof AutoCloseable)) continue;
                    ((AutoCloseable)((Object)oldLogger)).close();
                }
                catch (Throwable e) {
                    entry.getValue().error(e, "Failed to close the old logger {}", oldLogger);
                }
            }
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> void update(ConsumeProcessor<? super DynamicLogger, ? extends E> updateProcessor) {
        DynamicLoggerFactory dynamicLoggerFactory = this;
        synchronized (dynamicLoggerFactory) {
            for (Map.Entry<String, DynamicLogger> entry : this.loggerMap.entrySet()) {
                try {
                    updateProcessor.process(entry.getValue());
                }
                catch (Throwable e) {
                    entry.getValue().error(e, "Failed to close the old logger {}", entry.getKey());
                }
            }
        }
    }
}

