/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.logger;

import io.basc.framework.logger.Logger;
import io.basc.framework.util.FormatUtils;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JdkLogger
implements Logger {
    private final java.util.logging.Logger logger;

    public JdkLogger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Override
    public Level getLevel() {
        return this.logger.getLevel();
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    public java.util.logging.Logger getTargetLogger() {
        return this.logger;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    @Override
    public void log(LogRecord record) {
        String message = FormatUtils.formatPlaceholder(record.getMessage(), null, record.getParameters());
        record.setMessage(message);
        record.setParameters(null);
        this.logger.log(record);
    }

    @Override
    public void setLevel(Level level) {
        this.logger.setLevel(level);
        for (java.util.logging.Logger parent = this.logger; parent != null; parent = parent.getParent()) {
            for (Handler handler : parent.getHandlers()) {
                handler.setLevel(level);
            }
            if (!parent.getUseParentHandlers()) break;
        }
    }
}

