/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.core.annotation.MultiAnnotatedElement;
import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.lang.NestedExceptionUtils;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.mapper.FieldDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class AbstractFieldDescriptor
extends MultiAnnotatedElement
implements FieldDescriptor {
    private final Class<?> sourceClass;
    private final Field field;
    private final Method method;

    public AbstractFieldDescriptor(Class<?> sourceClass, Field field, Method method) {
        super(method, field);
        this.sourceClass = sourceClass;
        this.field = field;
        this.method = method;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.sourceClass;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isSynthetic() {
        Method method = this.getMethod();
        if (method != null && this.field != null) {
            return method.isSynthetic() || this.field.isSynthetic();
        }
        if (method != null) {
            return method.isSynthetic();
        }
        if (this.field != null) {
            return this.field.isSynthetic();
        }
        return false;
    }

    @Override
    public int getModifiers() {
        Method method = this.getMethod();
        Field field = this.getField();
        if (method != null && field != null) {
            return method.getModifiers() | field.getModifiers();
        }
        if (method != null) {
            return method.getModifiers();
        }
        if (field != null) {
            return field.getModifiers();
        }
        return 0;
    }

    protected UnsupportedException createNotSupportException() {
        return new UnsupportedException("class=[" + this.sourceClass + "] field [" + this.getName() + "]");
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof FieldDescriptor) {
            return this.getType().equals(((FieldDescriptor)obj).getType()) && ((FieldDescriptor)obj).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + this.getType().hashCode();
    }

    @Override
    public String toString() {
        if (this.field == null && this.method == null) {
            return "declaringClass [" + this.getDeclaringClass() + "] name [" + this.getName() + "]";
        }
        StringBuilder sb = new StringBuilder();
        if (this.field != null) {
            sb.append("field[").append(this.field).append("]");
        }
        if (this.method != null) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append("method[").append(this.method).append("]");
        }
        return sb.toString();
    }

    public Object get(Object instance) {
        Method method = this.getMethod();
        if (method != null) {
            try {
                return ReflectionUtils.invoke(method, Modifier.isStatic(method.getModifiers()) ? null : instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(this.toString() + " instance [" + instance + "]", NestedExceptionUtils.excludeInvalidNestedExcpetion(e));
            }
        }
        Field field = this.getField();
        if (field != null) {
            try {
                return ReflectionUtils.get(field, Modifier.isStatic(field.getModifiers()) ? null : instance);
            }
            catch (Exception e) {
                throw new RuntimeException(this.toString() + " instance [" + instance + "]", NestedExceptionUtils.excludeInvalidNestedExcpetion(e));
            }
        }
        throw this.createNotSupportException();
    }

    public void set(Object instance, Object value) {
        Method method = this.getMethod();
        if (method != null) {
            try {
                ReflectionUtils.invoke(method, Modifier.isStatic(method.getModifiers()) ? null : instance, value);
            }
            catch (Exception e) {
                throw new RuntimeException(this.toString() + " instance [" + instance + "] value [" + value + "]", NestedExceptionUtils.excludeInvalidNestedExcpetion(e));
            }
            return;
        }
        Field field = this.getField();
        if (field != null) {
            try {
                ReflectionUtils.set(field, Modifier.isStatic(field.getModifiers()) ? null : instance, value);
            }
            catch (Exception e) {
                throw new RuntimeException(this.toString() + " instance [" + instance + "] value [" + value + "]", NestedExceptionUtils.excludeInvalidNestedExcpetion(e));
            }
            return;
        }
        throw this.createNotSupportException();
    }
}

