/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.convert.ConversionException;
import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.mapper.ObjectAccess;
import io.basc.framework.mapper.Parameter;
import io.basc.framework.util.CollectionFactory;
import io.basc.framework.util.ConvertibleEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;

public class AnyMapAccess<E extends Throwable>
implements ObjectAccess<E> {
    private final ConversionService conversionService;
    private Map map;
    private final TypeDescriptor mapType;

    public AnyMapAccess(Map map, TypeDescriptor mapType, ConversionService conversionService) {
        this.map = map;
        this.mapType = mapType;
        this.conversionService = conversionService;
    }

    @Override
    public Enumeration<String> keys() throws ConversionException {
        if (this.map == null || this.map.isEmpty()) {
            return Collections.emptyEnumeration();
        }
        return new ConvertibleEnumeration<Object, String>(Collections.enumeration(this.map.keySet()), e -> this.conversionService.convert(e, this.mapType.getElementTypeDescriptor(), String.class));
    }

    @Override
    public Parameter get(String name) throws ConversionException {
        if (this.map == null) {
            return null;
        }
        Object value = this.map.get(name);
        if (value == null) {
            return null;
        }
        return new Parameter(name, value);
    }

    @Override
    public void set(Parameter parameter) throws ConversionException {
        if (parameter == null || parameter.isEmpty()) {
            return;
        }
        if (this.map == null) {
            this.map = CollectionFactory.createMap(this.mapType.getType(), this.mapType.getMapKeyTypeDescriptor().getType(), 16);
        }
        String key = parameter.getName();
        key = this.conversionService.convert(key, this.mapType.getMapKeyTypeDescriptor());
        if (parameter.isPresent()) {
            this.map.put(key, parameter.convert(this.mapType.getMapValueTypeDescriptor(), this.conversionService));
        } else {
            this.map.remove(key);
        }
    }
}

