/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.core.annotation.AnnotatedElementUtils;
import io.basc.framework.core.annotation.AnnotatedElementWrapper;
import io.basc.framework.core.annotation.MultiAnnotatedElement;
import io.basc.framework.mapper.DefaultParameterDescriptor;
import io.basc.framework.mapper.ParameterDescriptor;
import io.basc.framework.mapper.ParameterDescriptors;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Iterator;

public class DefaultParameterDescriptors<T>
extends AnnotatedElementWrapper<AnnotatedElement>
implements ParameterDescriptors {
    private final T source;
    private final Class<?> declaringClass;
    private final ParameterDescriptor[] parameterDescriptors;

    public DefaultParameterDescriptors(T source, Class<?> declaringClass, AnnotatedElement annotatedElement, ParameterDescriptor[] parameterDescriptors) {
        super(annotatedElement);
        this.source = source;
        this.declaringClass = declaringClass;
        this.parameterDescriptors = parameterDescriptors;
    }

    public DefaultParameterDescriptors(Class<?> declaringClass, T source, String[] names, Annotation[][] annotations, AnnotatedElement commonAnnotations, Type[] genericTypes, Class<?>[] types) {
        super(commonAnnotations);
        this.source = source;
        this.declaringClass = declaringClass;
        this.parameterDescriptors = new ParameterDescriptor[names.length];
        for (int index = 0; index < names.length; ++index) {
            AnnotatedElement annotatedElement = MultiAnnotatedElement.forAnnotatedElements(AnnotatedElementUtils.forAnnotations(annotations[index]), commonAnnotations);
            this.parameterDescriptors[index] = new DefaultParameterDescriptor(names[index], annotatedElement, types[index], genericTypes[index]);
        }
    }

    @Override
    public ParameterDescriptor[] toArray() {
        return (ParameterDescriptor[])this.parameterDescriptors.clone();
    }

    public T getSource() {
        return this.source;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Iterator<ParameterDescriptor> iterator() {
        return new InternalIterator();
    }

    @Override
    public int size() {
        return this.parameterDescriptors == null ? 0 : this.parameterDescriptors.length;
    }

    @Override
    public Class<?>[] getTypes() {
        Class[] types = new Class[this.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.parameterDescriptors[i].getType();
        }
        return types;
    }

    @Override
    public ParameterDescriptor getParameterDescriptor(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException(index + "");
        }
        return this.parameterDescriptors[index];
    }

    @Override
    public ParameterDescriptor getParameterDescriptor(String name) {
        for (ParameterDescriptor parameterDescriptor : this) {
            if (!parameterDescriptor.getName().equals(name)) continue;
            return parameterDescriptor;
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.source);
    }

    private class InternalIterator
    implements Iterator<ParameterDescriptor> {
        private int index = 0;

        private InternalIterator() {
        }

        @Override
        public boolean hasNext() {
            return DefaultParameterDescriptors.this.parameterDescriptors != null && this.index < DefaultParameterDescriptors.this.parameterDescriptors.length;
        }

        @Override
        public ParameterDescriptor next() {
            return DefaultParameterDescriptors.this.getParameterDescriptor(this.index++);
        }
    }
}

