/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.Fields;
import io.basc.framework.mapper.ToMap;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.StringUtils;
import io.basc.framework.value.Value;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MapperUtils {
    private MapperUtils() {
    }

    public static String getGetterMethodName(java.lang.reflect.Field field) {
        String name = field.getName();
        if (field.getType() == Boolean.TYPE) {
            if (name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2))) {
                return name;
            }
            return "is" + StringUtils.toUpperCase(name, 0, 1);
        }
        return "get" + StringUtils.toUpperCase(name, 0, 1);
    }

    public static String getSetterMethodName(java.lang.reflect.Field field) {
        String name = field.getName();
        if (field.getType() == Boolean.TYPE && name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2))) {
            return name.substring(2);
        }
        return "set" + StringUtils.toUpperCase(name, 0, 1);
    }

    public static void setValue(ConversionService conversionService, Object instance, Field field, Object value) {
        if (!field.isSupportSetter()) {
            throw new UnsupportedException(field.toString());
        }
        Object valueToUse = value != null && value instanceof Value ? ((Value)value).getAsObject(field.getSetter().getGenericType()) : conversionService.convert(value, value == null ? null : TypeDescriptor.forObject(value), new TypeDescriptor(field.getSetter()));
        field.getSetter().set(instance, valueToUse);
    }

    public static Map toMap(Object instance) {
        return MapperUtils.toMap(instance, true);
    }

    public static Map toMap(Object instance, boolean recursion) {
        if (instance == null) {
            return Collections.emptyMap();
        }
        if (instance instanceof ToMap) {
            ToMap toMap = (ToMap)instance;
            return recursion ? MapperUtils.parseMap(toMap.toMap()) : toMap.toMap();
        }
        if (instance instanceof Map) {
            return MapperUtils.parseMap((Map)instance);
        }
        if (Value.isBaseType(instance.getClass())) {
            throw new UnsupportedException(instance.getClass().getName());
        }
        Map valueMap = ((Fields)((Fields)Fields.getFields(instance.getClass()).ignoreStatic()).all()).getValueMap(instance);
        return recursion ? MapperUtils.parseMap(valueMap) : valueMap;
    }

    private static Map parseMap(Map map) {
        if (CollectionUtils.isEmpty(map)) {
            return Collections.EMPTY_MAP;
        }
        Set entries = map.entrySet();
        LinkedHashMap valueMap = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            valueMap.put(entry.getKey(), MapperUtils.parseValue(entry.getValue()));
        }
        return valueMap;
    }

    private static Object parseValue(Object value) {
        if (value == null) {
            return value;
        }
        if (Value.isBaseType(value.getClass())) {
            return value;
        }
        if (value instanceof ToMap) {
            return MapperUtils.parseMap(((ToMap)value).toMap());
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            if (CollectionUtils.isEmpty(list)) {
                return value;
            }
            ArrayList<Object> newList = new ArrayList<Object>(list.size());
            for (Object v : list) {
                newList.add(MapperUtils.parseValue(v));
            }
            return newList;
        }
        if (value instanceof Map) {
            return MapperUtils.parseMap((Map)value);
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                return value;
            }
            Object[] array = new Object[len];
            for (int i = 0; i < len; ++i) {
                array[i] = MapperUtils.parseValue(Array.get(value, i));
            }
            return array;
        }
        Map<String, Object> valueMap = ((Fields)((Fields)Fields.getFields(value.getClass()).ignoreStatic()).all()).getValueMap(value);
        return MapperUtils.parseMap(valueMap);
    }

    public static void appendToMap(Properties properties, Map<String, String> map) {
        if (properties == null || map == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(entry.getKey() == null ? null : entry.getKey().toString(), entry.getValue() == null ? null : entry.getValue().toString());
        }
    }
}

