/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.Parameter;
import io.basc.framework.util.StringUtils;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Function;

public interface ObjectAccess<E extends Throwable> {
    public Enumeration<String> keys() throws E;

    public Parameter get(String var1) throws E;

    public void set(Parameter var1) throws E;

    default public void set(Iterable<? extends Parameter> parameters) throws E {
        if (parameters == null) {
            return;
        }
        this.set(parameters.iterator());
    }

    default public void set(Iterator<? extends Parameter> parameters) throws E {
        if (parameters == null) {
            return;
        }
        while (parameters.hasNext()) {
            this.set(parameters.next());
        }
    }

    default public void copy(ObjectAccess<? extends E> targetAccess) throws E {
        this.copy(targetAccess, Function.identity());
    }

    default public void copyByPrefix(ObjectAccess<? extends E> targetAccess, String prefix) throws E {
        this.copy(targetAccess, StringUtils.isEmpty(prefix) ? null : key -> {
            if (prefix == null || key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return null;
        });
    }

    default public void copy(ObjectAccess<? extends E> targetAccess, @Nullable Function<String, String> keyFunction) throws E {
        if (targetAccess == null) {
            return;
        }
        Enumeration<String> keys = this.keys();
        if (keys == null) {
            return;
        }
        while (keys.hasMoreElements()) {
            String useKey;
            String key = keys.nextElement();
            if (key == null) continue;
            String string = useKey = keyFunction == null ? key : keyFunction.apply(key);
            if (useKey == null) continue;
            Parameter parameter = this.get(key);
            if (!StringUtils.equals(key, useKey)) {
                parameter = parameter.rename(useKey);
            }
            targetAccess.set(parameter);
        }
    }
}

