/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.convert.ConverterNotFoundException;
import io.basc.framework.convert.ReversibleMapperFactory;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.ObjectAccess;
import io.basc.framework.mapper.ObjectAccessFactoryRegistry;
import io.basc.framework.mapper.Parameter;
import io.basc.framework.mapper.Structure;
import io.basc.framework.mapper.StructureFactory;
import io.basc.framework.util.XUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public interface ObjectMapper<S, E extends Throwable>
extends ReversibleMapperFactory<S, E>,
StructureFactory,
ObjectAccessFactoryRegistry<E> {
    @Override
    default public Object convert(S source, Structure<? extends Field> targetStructure) throws E {
        return this.convert(source, TypeDescriptor.forObject(source), TypeDescriptor.valueOf(targetStructure.getSourceClass()), targetStructure);
    }

    @Override
    default public Object convert(S source, TypeDescriptor sourceType, TypeDescriptor targetType) throws E {
        if (this.canDirectlyConvert(sourceType, targetType)) {
            return source;
        }
        if (this.isConverterRegistred(targetType.getType())) {
            return ReversibleMapperFactory.super.convert(source, sourceType, targetType);
        }
        Object target = this.newInstance(targetType);
        if (target == null) {
            return null;
        }
        this.transform(source, sourceType, target, targetType);
        return target;
    }

    default public Object convert(S source, TypeDescriptor sourceType, TypeDescriptor targetType, Structure<? extends Field> targetStructure) throws E {
        Object target = this.newInstance(targetType);
        if (target == null) {
            return null;
        }
        this.transform(source, sourceType, target, targetType, targetStructure);
        return target;
    }

    default public <T> void copy(T source, TypeDescriptor sourceType, T target, TypeDescriptor targetType, Iterator<? extends Field> properties) throws E {
        while (properties.hasNext()) {
            Parameter value;
            Field field = properties.next();
            if (!field.isSupportGetter() || !field.isSupportSetter() || (value = field.getParameter(source)) == null || !value.isPresent()) continue;
            field.set(target, value);
        }
    }

    default public <T> void copy(T source, TypeDescriptor sourceType, T target, TypeDescriptor targetType, Structure<? extends Field> structure) throws E {
        Iterator iterator = structure.pages().iterator();
        while (iterator.hasNext()) {
            Structure useStructure = (Structure)iterator.next();
            this.copy(source, sourceType, target, targetType, useStructure.iterator());
        }
    }

    default public <R extends S> R invert(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, TypeDescriptor targetType) throws E {
        Object target = this.newInstance(targetType);
        if (target == null) {
            return null;
        }
        this.transform(source, sourceType, sourceStructure, target, targetType);
        return (R)target;
    }

    @Override
    default public S invert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) throws E {
        if (this.canDirectlyConvert(sourceType, targetType)) {
            return (S)source;
        }
        if (this.isInverterRegistred(sourceType.getType())) {
            return (S)ReversibleMapperFactory.super.invert(source, sourceType, targetType);
        }
        Object target = this.newInstance(targetType);
        if (target == null) {
            return null;
        }
        this.reverseTransform(source, sourceType, (S)target, targetType);
        return (S)target;
    }

    @Override
    default public void reverseTransform(Object source, TypeDescriptor sourceType, S target, TypeDescriptor targetType) throws E {
        if (this.isReverseTransformerRegistred(sourceType.getType())) {
            ReversibleMapperFactory.super.reverseTransform(source, sourceType, target, targetType);
            return;
        }
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(source, sourceType, this.getObjectAccess((Object)target, targetType));
            return;
        }
        if (this.isObjectAccessFactoryRegistred(sourceType.getType())) {
            this.transform(this.getObjectAccess(source, sourceType), target, targetType);
            return;
        }
        if (targetType.getType() == sourceType.getType() || sourceType.getType().isAssignableFrom(targetType.getType())) {
            this.copy(target, targetType, source, sourceType, this.getStructure(targetType.getType()));
            return;
        }
        this.transform(target, targetType, this.getStructure(targetType.getType()), source, sourceType, this.getStructure(sourceType.getType()));
    }

    @Override
    default public void transform(Object source, Structure<? extends Field> sourceStructure, Object target) throws E {
        this.transform(source, TypeDescriptor.valueOf(sourceStructure.getSourceClass()), sourceStructure, target, TypeDescriptor.forObject(target));
    }

    default public void transform(Object source, TypeDescriptor sourceType, Iterator<? extends Field> sourceProperties, Object target, TypeDescriptor targetType, Iterator<? extends Field> targetProperties) throws E {
        Comparator comparator = (left, right) -> {
            if (left.getDeclaringClass() == right.getDeclaringClass()) {
                if (left.getType() == right.getType()) {
                    return 0;
                }
                return right.getType().isAssignableFrom(left.getType()) ? 1 : -1;
            }
            return right.getDeclaringClass().isAssignableFrom(left.getDeclaringClass()) ? 1 : -1;
        };
        List targetFields = XUtils.stream(targetProperties).filter(e -> e.isSupportSetter()).sorted((left, right) -> comparator.compare(left.getGetter(), right.getGetter())).collect(Collectors.toList());
        XUtils.stream(sourceProperties).filter(e -> e.isSupportGetter()).sorted((left, right) -> comparator.compare(left.getSetter(), right.getSetter())).forEachOrdered(sourceField -> {
            Parameter value = sourceField.getParameter(source);
            if (value == null || !value.isPresent()) {
                return;
            }
            for (Field targetField : targetFields) {
                if (!sourceField.test(targetField)) continue;
                targetField.set(target, value);
            }
        });
    }

    @Override
    default public void transform(Object source, TypeDescriptor sourceType, Iterator<? extends Field> sourceProperties, ObjectAccess<? extends E> targetAccess) throws E {
        while (sourceProperties.hasNext()) {
            Parameter parameter;
            Field field = sourceProperties.next();
            if (!field.isSupportGetter() || (parameter = field.getParameter(source)) == null || !parameter.isPresent()) continue;
            targetAccess.set(parameter);
        }
    }

    default public void transform(Object source, TypeDescriptor sourceType, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure) throws E {
        if (this.isObjectAccessFactoryRegistred(sourceType.getType())) {
            this.transform(this.getObjectAccess(source, sourceType), target, targetType, targetStructure);
        } else {
            this.transform(source, sourceType, this.getStructure(sourceType.getType()), target, targetType, targetStructure);
        }
    }

    @Override
    default public void transform(Object source, TypeDescriptor sourceType, ObjectAccess<? extends E> targetAccess) throws E {
        if (source == null) {
            return;
        }
        if (this.isObjectAccessFactoryRegistred(sourceType.getType())) {
            this.transform(this.getObjectAccess(source, sourceType), targetAccess);
            return;
        }
        Structure<? extends Field> sourceStructure = this.getStructure(sourceType.getType());
        this.transform(source, sourceType, sourceStructure, targetAccess);
    }

    default public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, Object target, TypeDescriptor targetType) throws E {
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(source, sourceType, sourceStructure, this.getObjectAccess(target, targetType));
        } else {
            this.transform(source, sourceType, sourceStructure, target, targetType, this.getStructure(targetType.getType()));
        }
    }

    default public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure) throws E {
        this.transform(source, sourceType, ((Structure)sourceStructure.all()).stream().iterator(), target, targetType, ((Structure)targetStructure.all()).stream().iterator());
    }

    @Override
    default public void transform(Object source, TypeDescriptor sourceType, Structure<? extends Field> sourceStructure, ObjectAccess<? extends E> targetAccess) throws E {
        Iterator iterator = sourceStructure.pages().iterator();
        while (iterator.hasNext()) {
            Structure structure = (Structure)iterator.next();
            this.transform(source, sourceType, structure.iterator(), targetAccess);
        }
    }

    @Override
    default public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType) throws E {
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(sourceAccess, this.getObjectAccess(target, targetType));
            return;
        }
        Structure<? extends Field> targetStructure = this.getStructure(targetType.getType());
        this.transform(sourceAccess, target, targetType, targetStructure);
    }

    default public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, Iterator<? extends Field> targetProperties) throws E {
        while (targetProperties.hasNext()) {
            Parameter parameter;
            Field field = targetProperties.next();
            if (!field.isSupportSetter() || (parameter = sourceAccess.get(field.getName())) == null || !parameter.isPresent()) continue;
            field.set(target, parameter);
        }
    }

    default public void transform(ObjectAccess<E> sourceAccess, Object target, TypeDescriptor targetType, Structure<? extends Field> targetStructure) throws E {
        Iterator iterator = targetStructure.pages().iterator();
        while (iterator.hasNext()) {
            Structure structure = (Structure)iterator.next();
            this.transform(sourceAccess, target, targetType, structure.iterator());
        }
    }

    @Override
    default public void transform(ObjectAccess<E> sourceAccess, ObjectAccess<? extends E> targetAccess) throws E {
        sourceAccess.copy(targetAccess);
    }

    @Override
    default public void transform(S source, TypeDescriptor sourceType, Object target, TypeDescriptor targetType) throws E, ConverterNotFoundException {
        if (this.isTransformerRegistred(targetType.getType())) {
            ReversibleMapperFactory.super.transform(source, sourceType, target, targetType);
            return;
        }
        if (this.isObjectAccessFactoryRegistred(sourceType.getType())) {
            this.transform(this.getObjectAccess((Object)source, sourceType), target, targetType);
            return;
        }
        if (this.isObjectAccessFactoryRegistred(targetType.getType())) {
            this.transform(source, sourceType, this.getObjectAccess(target, targetType));
            return;
        }
        if (targetType.getType() == sourceType.getType() || targetType.getType().isAssignableFrom(sourceType.getType())) {
            this.copy(source, sourceType, target, targetType, this.getStructure(targetType.getType()));
            return;
        }
        this.transform(source, sourceType, this.getStructure(sourceType.getType()), target, targetType, this.getStructure(targetType.getType()));
    }
}

