/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.mapper;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.lang.Nullable;
import io.basc.framework.mapper.ParameterDescriptor;
import io.basc.framework.util.Assert;
import io.basc.framework.util.StringUtils;
import io.basc.framework.value.AnyValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class Parameter
extends AnyValue
implements ParameterDescriptor {
    public static final Parameter INVALID = new Parameter(null);
    private final String name;

    public Parameter(String name) {
        this(name, (Object)null, null);
    }

    public Parameter(String name, Object value) {
        this(name, value, null);
    }

    public Parameter(String name, Object value, @Nullable TypeDescriptor typeDescriptor) {
        super(value, typeDescriptor);
        this.name = name;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getTypeDescriptor().getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getTypeDescriptor().getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getTypeDescriptor().getDeclaredAnnotations();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.getTypeDescriptor().getType();
    }

    @Override
    public Type getGenericType() {
        return this.getTypeDescriptor().getResolvableType().getType();
    }

    @Override
    public Parameter rename(String name) {
        Assert.requiredArgument(StringUtils.isNotEmpty(name), "name");
        return new Parameter(name, (Object)this);
    }

    @Override
    public boolean isPresent() {
        return !StringUtils.isEmpty(this.name) && super.isPresent();
    }
}

