/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.math;

import io.basc.framework.math.AbstractNumberHolder;
import io.basc.framework.math.NumberHolder;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigIntegerHolder
extends AbstractNumberHolder {
    private static final long serialVersionUID = 1L;
    public static final BigIntegerHolder ZERO = new BigIntegerHolder(BigInteger.ZERO);
    public static final BigIntegerHolder ONE = new BigIntegerHolder(BigInteger.ONE);
    private BigInteger bigInteger;

    public BigIntegerHolder(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }

    @Override
    public int compareTo(NumberHolder o) {
        if (o instanceof BigIntegerHolder) {
            return this.bigInteger.compareTo(((BigIntegerHolder)o).bigInteger);
        }
        return super.compareTo(o);
    }

    @Override
    protected NumberHolder addInternal(NumberHolder numberHolder) {
        return new BigIntegerHolder(this.bigInteger.add(numberHolder.toBigDecimal().toBigIntegerExact()));
    }

    @Override
    protected NumberHolder subtractInternal(NumberHolder numberHolder) {
        return new BigIntegerHolder(this.bigInteger.subtract(numberHolder.toBigDecimal().toBigIntegerExact()));
    }

    @Override
    protected NumberHolder multiplyInternal(NumberHolder numberHolder) {
        return new BigIntegerHolder(this.bigInteger.multiply(numberHolder.toBigDecimal().toBigIntegerExact()));
    }

    @Override
    protected NumberHolder divideInternal(NumberHolder numberHolder) {
        return new BigIntegerHolder(this.bigInteger.divide(numberHolder.toBigDecimal().toBigIntegerExact()));
    }

    @Override
    protected NumberHolder remainderInternal(NumberHolder numberHolder) {
        return new BigIntegerHolder(this.bigInteger.remainder(numberHolder.toBigDecimal().toBigIntegerExact()));
    }

    @Override
    protected NumberHolder powInternal(NumberHolder numberHolder) {
        return new BigIntegerHolder(this.bigInteger.pow(numberHolder.toBigDecimal().intValueExact()));
    }

    @Override
    public NumberHolder abs() {
        return new BigIntegerHolder(this.bigInteger.abs());
    }

    @Override
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.bigInteger);
    }

    public int hashCode() {
        return this.bigInteger.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof BigIntegerHolder) {
            return this.bigInteger.equals(((BigIntegerHolder)obj).bigInteger);
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return this.bigInteger.toString();
    }
}

