/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.math;

import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.math.Calculator;
import io.basc.framework.math.NumberHolder;

public enum Calculators implements Calculator
{
    POW("^"),
    MULTIPLY("*"),
    DIVIDE("/"),
    REMAINDER("%"),
    ADD("+"),
    SUBTRACT("-");

    public static final Calculator[][] GROUPS;
    private final String operator;

    private Calculators(String operator) {
        this.operator = operator;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public NumberHolder eval(NumberHolder left, NumberHolder right) {
        switch (this) {
            case ADD: {
                return left.add(right);
            }
            case SUBTRACT: {
                return left.subtract(right);
            }
            case MULTIPLY: {
                return left.multiply(right);
            }
            case DIVIDE: {
                return left.divide(right);
            }
            case REMAINDER: {
                return left.remainder(right);
            }
            case POW: {
                return left.pow(right);
            }
        }
        throw new UnsupportedException(this.toString());
    }

    static {
        GROUPS = new Calculator[][]{{POW}, {MULTIPLY, DIVIDE, REMAINDER}, {ADD, SUBTRACT}};
    }
}

