/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.math;

import io.basc.framework.math.BigDecimalHolder;
import io.basc.framework.math.BigIntegerHolder;
import io.basc.framework.math.MathUtils;
import io.basc.framework.math.NumberHolder;
import io.basc.framework.math.gcd.GreatestCommonDivisor;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Fraction
extends Number
implements NumberHolder {
    private static final long serialVersionUID = 1L;
    public static final Fraction ZERO = new Fraction(BigIntegerHolder.ZERO, BigIntegerHolder.ONE);
    private final NumberHolder molecule;
    private final NumberHolder denominator;
    private GreatestCommonDivisor greatestCommonDivisor = MathUtils.getGreatestCommonDivisor();

    public Fraction(BigDecimal bigDecimal) {
        this(new BigDecimalHolder(bigDecimal), new BigDecimalHolder(BigDecimal.ONE));
    }

    public Fraction(String molecule, String denominator) {
        this(new BigDecimalHolder(molecule), new BigDecimalHolder(denominator));
    }

    public Fraction(String molecule, String denominator, int scale, RoundingMode roundingMode) {
        this(new BigDecimalHolder(molecule, scale, roundingMode), new BigDecimalHolder(denominator, scale, roundingMode));
    }

    public Fraction(NumberHolder molecule, NumberHolder denominator) {
        this.molecule = molecule;
        this.denominator = denominator;
    }

    public GreatestCommonDivisor getGreatestCommonDivisor() {
        return this.greatestCommonDivisor;
    }

    public void setGreatestCommonDivisor(GreatestCommonDivisor greatestCommonDivisor) {
        this.greatestCommonDivisor = greatestCommonDivisor;
    }

    private Fraction toFractionNumberHolder(NumberHolder numberHolder) {
        return new Fraction(numberHolder.multiply(this.denominator), this.denominator);
    }

    @Override
    public Fraction add(NumberHolder numberHolder) {
        if (numberHolder instanceof Fraction) {
            Fraction summand = (Fraction)numberHolder;
            return new Fraction(this.molecule.multiply(summand.denominator).add(summand.molecule.multiply(this.denominator)), this.denominator.multiply(summand.denominator)).reduction();
        }
        return this.add(this.toFractionNumberHolder(numberHolder));
    }

    @Override
    public Fraction subtract(NumberHolder numberHolder) {
        if (numberHolder instanceof Fraction) {
            Fraction minuend = (Fraction)numberHolder;
            return new Fraction(this.molecule.multiply(minuend.denominator).subtract(minuend.molecule.multiply(this.denominator)), this.denominator.multiply(minuend.denominator)).reduction();
        }
        return this.subtract(this.toFractionNumberHolder(numberHolder));
    }

    @Override
    public Fraction multiply(NumberHolder numberHolder) {
        if (numberHolder instanceof Fraction) {
            Fraction multiplicand = (Fraction)numberHolder;
            return new Fraction(this.molecule.multiply(multiplicand.molecule), this.denominator.multiply(multiplicand.denominator)).reduction();
        }
        return this.multiply(this.toFractionNumberHolder(numberHolder));
    }

    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.molecule);
    }

    @Override
    public Fraction divide(NumberHolder numberHolder) {
        if (numberHolder instanceof Fraction) {
            return this.multiply(((Fraction)numberHolder).reciprocal()).reduction();
        }
        return this.divide(this.toFractionNumberHolder(numberHolder));
    }

    public NumberHolder remainder() {
        return this.molecule.remainder(this.denominator);
    }

    @Override
    public NumberHolder remainder(NumberHolder numberHolder) {
        return new BigDecimalHolder(this.toBigDecimal().remainder(numberHolder.toBigDecimal()));
    }

    @Override
    public NumberHolder pow(NumberHolder numberHolder) {
        return new Fraction(this.molecule.pow(numberHolder), this.denominator.pow(numberHolder));
    }

    @Override
    public BigDecimal toBigDecimal() {
        return this.molecule.divide(this.denominator).toBigDecimal();
    }

    public final NumberHolder getMolecule() {
        return this.molecule;
    }

    public final NumberHolder getDenominator() {
        return this.denominator;
    }

    @Override
    public Fraction abs() {
        return new Fraction(this.molecule.abs(), this.denominator.abs());
    }

    private String toString(NumberHolder numberHolder) {
        return numberHolder instanceof Fraction ? "(" + numberHolder + ")" : numberHolder.toString();
    }

    public String toString() {
        return this.toString(this.molecule) + "/" + this.toString(this.denominator);
    }

    @Override
    public int compareTo(NumberHolder o) {
        if (o instanceof Fraction) {
            return this.molecule.multiply(((Fraction)o).denominator).compareTo(this.denominator.multiply(((Fraction)o).molecule));
        }
        return this.compareTo(this.toFractionNumberHolder(o));
    }

    public Fraction reduction() {
        if (this.molecule instanceof Fraction) {
            return ((Fraction)this.molecule).divide(this.denominator).reduction();
        }
        if (this.denominator instanceof Fraction) {
            return this.toFractionNumberHolder(this.molecule).divide((Fraction)this.denominator).reciprocal();
        }
        BigDecimal molecule = this.molecule.toBigDecimal();
        if (molecule.doubleValue() == 0.0) {
            return ZERO;
        }
        if (molecule.doubleValue() == 1.0) {
            return this;
        }
        BigDecimal denominator = this.denominator.toBigDecimal();
        BigDecimal gcd = this.getGreatestCommonDivisor().gcd(molecule, denominator);
        if (gcd.equals(BigDecimal.ONE)) {
            return this;
        }
        return new Fraction(new BigDecimalHolder(molecule.divide(gcd)), new BigDecimalHolder(denominator.divide(gcd)));
    }

    @Override
    public int intValue() {
        return this.toBigDecimal().intValue();
    }

    @Override
    public long longValue() {
        return this.toBigDecimal().longValue();
    }

    @Override
    public float floatValue() {
        return this.toBigDecimal().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }
}

