/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.math.gcd;

import io.basc.framework.math.BigIntegerHolder;
import io.basc.framework.math.NumberHolder;
import io.basc.framework.math.gcd.GreatestCommonDivisor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DivisionAlgorithm
implements GreatestCommonDivisor {
    @Override
    public int gcd(int m, int n) {
        int a = Math.abs(m);
        int b = Math.abs(n);
        do {
            if ((a %= b) != 0) continue;
            return b;
        } while ((b %= a) != 0);
        return a;
    }

    @Override
    public BigInteger gcd(BigInteger m, BigInteger n) {
        BigInteger a = m.abs();
        BigInteger b = n.abs();
        do {
            if (!(a = a.remainder(b)).equals(BigInteger.ZERO)) continue;
            return b;
        } while (!(b = b.remainder(a)).equals(BigInteger.ZERO));
        return a;
    }

    @Override
    public BigDecimal gcd(BigDecimal m, BigDecimal n) {
        BigDecimal a = m.abs();
        BigDecimal b = n.abs();
        do {
            if (!(a = a.remainder(b)).equals(BigDecimal.ZERO)) continue;
            return b;
        } while (!(b = b.remainder(a)).equals(BigDecimal.ZERO));
        return a;
    }

    @Override
    public NumberHolder gcd(NumberHolder m, NumberHolder n) {
        NumberHolder a = m.abs();
        NumberHolder b = n.abs();
        do {
            if (!(a = a.remainder(b)).equals(BigIntegerHolder.ZERO)) continue;
            return b;
        } while (!(b = b.remainder(a)).equals(BigIntegerHolder.ZERO));
        return a;
    }
}

