/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net;

import io.basc.framework.net.MimeType;
import io.basc.framework.net.MimeTypeUtils;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class MimeTypes
implements Comparator<MimeType>,
Iterable<MimeType>,
Comparable<MimeTypes>,
Cloneable {
    public static final MimeTypes EMPTY = new MimeTypes(Collections.emptySortedSet());
    private final SortedSet<MimeType> mimeTypes;
    private boolean readyOnly;

    public MimeTypes() {
        this.mimeTypes = new TreeSet<MimeType>(this);
    }

    public MimeTypes(SortedSet<MimeType> mimeTypes) {
        this(mimeTypes, false);
    }

    public MimeTypes(String ... mimeTypes) {
        this.mimeTypes = new TreeSet<MimeType>(this);
        if (mimeTypes != null) {
            for (String mimeType : mimeTypes) {
                if (StringUtils.isEmpty(mimeType)) continue;
                this.mimeTypes.add(MimeTypeUtils.parseMimeType(mimeType));
            }
        }
    }

    protected MimeTypes(SortedSet<MimeType> mimeTypes, boolean readyOnly) {
        this.mimeTypes = readyOnly ? Collections.unmodifiableSortedSet(mimeTypes) : new TreeSet<MimeType>(mimeTypes);
        this.readyOnly = readyOnly;
    }

    @Override
    public Iterator<MimeType> iterator() {
        return Collections.unmodifiableCollection(this.mimeTypes).iterator();
    }

    public final SortedSet<MimeType> getMimeTypes() {
        return this.readyOnly ? Collections.unmodifiableSortedSet(this.mimeTypes) : this.mimeTypes;
    }

    public final List<String> getRawMimeTypes() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(this.mimeTypes.size());
        for (MimeType mimeType : this.mimeTypes) {
            list.add(mimeType.toString());
        }
        return list;
    }

    public boolean isEmpty() {
        return this.mimeTypes.isEmpty();
    }

    public final MimeTypes add(MimeType ... mimeTypes) {
        for (MimeType mimeType : mimeTypes) {
            this.mimeTypes.add(mimeType);
        }
        return this;
    }

    public final MimeTypes addAll(Iterable<? extends MimeType> mimeTypes) {
        for (MimeType mimeType : mimeTypes) {
            this.mimeTypes.add(mimeType);
        }
        return this;
    }

    public final boolean isReadyOnly() {
        return this.readyOnly;
    }

    public final MimeTypes readyOnly() {
        if (this.readyOnly) {
            return this;
        }
        return new MimeTypes(this.mimeTypes, true);
    }

    @Override
    public int compare(MimeType o1, MimeType o2) {
        return MimeTypeUtils.SPECIFICITY_COMPARATOR.compare(o1, o2);
    }

    @Override
    public int compareTo(MimeTypes o) {
        if (this.equals(o)) {
            return 0;
        }
        for (MimeType mimeType1 : this.mimeTypes) {
            for (MimeType mimeType2 : o.mimeTypes) {
                if (mimeType1.compareTo(mimeType2) <= 0) continue;
                return 1;
            }
        }
        return -1;
    }

    public boolean isCompatibleWith(MimeType mimeType) {
        for (MimeType mime : this.mimeTypes) {
            if (!mime.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }

    public MimeTypes clone() {
        return new MimeTypes(this.mimeTypes, this.readyOnly);
    }

    public int hashCode() {
        return this.mimeTypes.hashCode();
    }

    public String toString() {
        return MimeTypeUtils.toString(this.mimeTypes);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof MimeTypes) {
            return CollectionUtils.unorderedEquals(this.mimeTypes, ((MimeTypes)obj).mimeTypes);
        }
        return false;
    }
}

