/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net;

import io.basc.framework.util.StringUtils;

public enum ProtocolType {
    HTTP("http://"),
    HTTPS("https://"),
    HTTP_AUTO("//");

    private final String value;

    private ProtocolType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isProtocolType(String url) {
        return url == null ? false : url.startsWith(this.value);
    }

    public static ProtocolType getHttpProtocolType(String url) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        for (ProtocolType protocolType : ProtocolType.values()) {
            if (!url.startsWith(protocolType.getValue())) continue;
            return protocolType;
        }
        return null;
    }
}

