/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.message;

import io.basc.framework.util.AbstractMultiValueMap;
import io.basc.framework.util.CollectionFactory;
import io.basc.framework.util.LinkedCaseInsensitiveMap;
import io.basc.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Headers
extends AbstractMultiValueMap<String, String> {
    private static final long serialVersionUID = 1L;
    public static final Headers EMPTY = new Headers(Collections.emptyMap(), true);
    private Map<String, List<String>> headers;
    private boolean readyOnly;

    public Headers(boolean caseSensitiveKey) {
        this.headers = caseSensitiveKey ? new LinkedHashMap<String, List<String>>(8) : new LinkedCaseInsensitiveMap<List<String>>(8, Locale.ENGLISH);
    }

    public Headers(Map<String, List<String>> headers, boolean readyOnly) {
        this.headers = readyOnly ? Collections.unmodifiableMap(headers) : headers;
        this.readyOnly = readyOnly;
    }

    public Headers(Headers headers) {
        this.headers = headers.readyOnly ? headers.headers : CollectionFactory.clone(headers.headers);
        this.readyOnly = headers.readyOnly;
    }

    public void caseSensitiveKey(boolean caseSensitiveKey) {
        Map<String, List<String>> map = this.headers;
        if (caseSensitiveKey) {
            if (this.headers instanceof LinkedCaseInsensitiveMap) {
                map = new LinkedHashMap<String, List<String>>();
                map.putAll(this.headers);
            }
        } else if (!(this.headers instanceof LinkedCaseInsensitiveMap)) {
            map = new LinkedCaseInsensitiveMap<List<String>>(this.headers.size(), Locale.ENGLISH);
            map.putAll(this.headers);
        }
        this.headers = map;
    }

    public final boolean isReadyOnly() {
        return this.readyOnly;
    }

    public final boolean isCaseSensitiveKey() {
        return !(this.headers instanceof LinkedCaseInsensitiveMap);
    }

    public void readyOnly() {
        if (this.isReadyOnly()) {
            return;
        }
        this.readyOnly = true;
        this.headers = Collections.unmodifiableMap(this.headers);
    }

    public void readyOnly(boolean caseSensitiveKey) {
        this.caseSensitiveKey(caseSensitiveKey);
        this.readyOnly();
    }

    @Override
    protected final Map<String, List<String>> getTargetMap() {
        return this.headers;
    }

    public List<String> getValuesAsList(String headerName, String tokenize) {
        Object values = this.get(headerName);
        if (values != null) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String[] tokens;
                String value = (String)iterator.next();
                if (value == null) continue;
                for (String token : tokens = StringUtils.tokenizeToArray(value, tokenize)) {
                    result.add(token);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }
}

