/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.message.convert;

import io.basc.framework.convert.ConversionService;
import io.basc.framework.convert.ConversionServiceAware;
import io.basc.framework.convert.lang.ConfigurableConversionService;
import io.basc.framework.convert.support.DefaultConversionService;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.net.InetUtils;
import io.basc.framework.net.message.convert.ByteArrayMessageConverter;
import io.basc.framework.net.message.convert.HttpFormMessageConveter;
import io.basc.framework.net.message.convert.JsonMessageConverter;
import io.basc.framework.net.message.convert.MessageConverter;
import io.basc.framework.net.message.convert.MessageConverters;
import io.basc.framework.net.message.convert.ResourceMessageConverter;
import io.basc.framework.net.message.convert.StringMessageConverter;
import io.basc.framework.net.message.multipart.MultipartMessageConverter;

public class DefaultMessageConverters
extends MessageConverters {
    private final ConfigurableConversionService conversionService;

    public DefaultMessageConverters() {
        this.conversionService = new DefaultConversionService();
        this.afterConfigure();
    }

    public DefaultMessageConverters(ConversionService conversionService) {
        this.conversionService = new ConfigurableConversionService();
        this.conversionService.setAfterService(conversionService);
        this.afterConfigure();
    }

    protected void afterConfigure() {
        this.addService(new JsonMessageConverter());
        this.addService(new StringMessageConverter(this.conversionService));
        this.addService(new ByteArrayMessageConverter());
        this.addService(new HttpFormMessageConveter());
        this.addService(new MultipartMessageConverter(InetUtils.getMultipartMessageResolver()));
        this.addService(new ResourceMessageConverter());
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        if (this.conversionService.getAfterService() == null) {
            this.conversionService.configure(serviceLoaderFactory);
        }
        super.configure(serviceLoaderFactory);
    }

    public ConfigurableConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public void accept(MessageConverter service) {
        if (service instanceof ConversionServiceAware) {
            ((ConversionServiceAware)((Object)service)).setConversionService(this.conversionService);
        }
        super.accept(service);
    }
}

