/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.message.convert;

import io.basc.framework.codec.Encoder;
import io.basc.framework.codec.support.URLCodec;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.MediaType;
import io.basc.framework.net.MimeType;
import io.basc.framework.net.message.InputMessage;
import io.basc.framework.net.message.OutputMessage;
import io.basc.framework.net.message.convert.AbstractMessageConverter;
import io.basc.framework.net.message.convert.MessageConvertException;
import io.basc.framework.net.uri.UriUtils;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.StringUtils;
import java.io.IOException;
import java.util.Collection;

public class HttpFormMessageConveter
extends AbstractMessageConverter<Object> {
    public HttpFormMessageConveter() {
        this.supportMimeTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
    }

    @Override
    public boolean support(Class<?> clazz) {
        return !Collection.class.isAssignableFrom(clazz);
    }

    @Override
    protected Object readInternal(TypeDescriptor type, InputMessage inputMessage) throws IOException, MessageConvertException {
        String content = this.readTextBody(inputMessage);
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        MultiValueMap<String, String> map = UriUtils.getQueryParams(content);
        String json = this.getJsonSupport().toJsonString(map);
        return this.getJsonSupport().parseObject(json, type.getType());
    }

    @Override
    protected void writeInternal(TypeDescriptor type, Object body, MimeType contentType, OutputMessage outputMessage) throws IOException, MessageConvertException {
        String queryString = UriUtils.toQueryString(body, (Encoder<String, String>)new URLCodec(this.getCharset(outputMessage)));
        this.writeTextBody(queryString, contentType, outputMessage);
    }
}

