/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.uri;

import io.basc.framework.net.uri.UriComponents;
import io.basc.framework.net.uri.UriComponentsBuilder;
import io.basc.framework.net.uri.UriTemplateHandler;
import io.basc.framework.util.Assert;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractUriTemplateHandler
implements UriTemplateHandler {
    private String baseUrl;
    private final Map<String, Object> defaultUriVariables = new HashMap<String, Object>();

    public void setBaseUrl(String baseUrl) {
        if (baseUrl != null) {
            UriComponents uriComponents = UriComponentsBuilder.fromUriString(baseUrl).build();
            Assert.hasText(uriComponents.getScheme(), "'baseUrl' must have a scheme");
            Assert.hasText(uriComponents.getHost(), "'baseUrl' must have a host");
            Assert.isNull(uriComponents.getQuery(), "'baseUrl' cannot have a query");
            Assert.isNull(uriComponents.getFragment(), "'baseUrl' cannot have a fragment");
        }
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setDefaultUriVariables(Map<String, ?> defaultUriVariables) {
        this.defaultUriVariables.clear();
        if (defaultUriVariables != null) {
            this.defaultUriVariables.putAll(defaultUriVariables);
        }
    }

    public Map<String, ?> getDefaultUriVariables() {
        return Collections.unmodifiableMap(this.defaultUriVariables);
    }

    @Override
    public URI expand(String uriTemplate, Map<String, ?> uriVariables) {
        if (!this.getDefaultUriVariables().isEmpty()) {
            HashMap map = new HashMap();
            map.putAll(this.getDefaultUriVariables());
            map.putAll(uriVariables);
            uriVariables = map;
        }
        URI url = this.expandInternal(uriTemplate, uriVariables);
        return this.insertBaseUrl(url);
    }

    @Override
    public URI expand(String uriTemplate, Object ... uriVariables) {
        URI url = this.expandInternal(uriTemplate, uriVariables);
        return this.insertBaseUrl(url);
    }

    protected abstract URI expandInternal(String var1, Map<String, ?> var2);

    protected abstract URI expandInternal(String var1, Object ... var2);

    private URI insertBaseUrl(URI url) {
        try {
            String baseUrl = this.getBaseUrl();
            if (baseUrl != null && url.getHost() == null) {
                url = new URI(baseUrl + url.toString());
            }
            return url;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URL after inserting base URL: " + url, ex);
        }
    }
}

