/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.net.uri;

import io.basc.framework.net.uri.AbstractUriTemplateHandler;
import io.basc.framework.net.uri.UriComponents;
import io.basc.framework.net.uri.UriComponentsBuilder;
import io.basc.framework.net.uri.UriTemplateHandler;
import io.basc.framework.net.uri.UriUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultUriTemplateHandler
extends AbstractUriTemplateHandler {
    public static final UriTemplateHandler INSTANCE = new DefaultUriTemplateHandler();
    private boolean parsePath;
    private boolean strictEncoding;

    public void setParsePath(boolean parsePath) {
        this.parsePath = parsePath;
    }

    public boolean shouldParsePath() {
        return this.parsePath;
    }

    public void setStrictEncoding(boolean strictEncoding) {
        this.strictEncoding = strictEncoding;
    }

    public boolean isStrictEncoding() {
        return this.strictEncoding;
    }

    @Override
    protected URI expandInternal(String uriTemplate, Map<String, ?> uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = this.expandAndEncode(uriComponentsBuilder, uriVariables);
        return this.createUri(uriComponents);
    }

    @Override
    protected URI expandInternal(String uriTemplate, Object ... uriVariables) {
        UriComponentsBuilder uriComponentsBuilder = this.initUriComponentsBuilder(uriTemplate);
        UriComponents uriComponents = this.expandAndEncode(uriComponentsBuilder, uriVariables);
        return this.createUri(uriComponents);
    }

    protected UriComponentsBuilder initUriComponentsBuilder(String uriTemplate) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString(uriTemplate);
        if (this.shouldParsePath() && !this.isStrictEncoding()) {
            List<String> pathSegments = builder.build().getPathSegments();
            builder.replacePath(null);
            for (String pathSegment : pathSegments) {
                builder.pathSegment(pathSegment);
            }
        }
        return builder;
    }

    protected UriComponents expandAndEncode(UriComponentsBuilder builder, Map<String, ?> uriVariables) {
        if (!this.isStrictEncoding()) {
            return builder.buildAndExpand(uriVariables).encode();
        }
        HashMap<String, String> encodedUriVars = new HashMap<String, String>(uriVariables.size());
        for (Map.Entry<String, ?> entry : uriVariables.entrySet()) {
            encodedUriVars.put(entry.getKey(), this.applyStrictEncoding(entry.getValue()));
        }
        return builder.buildAndExpand(encodedUriVars);
    }

    protected UriComponents expandAndEncode(UriComponentsBuilder builder, Object[] uriVariables) {
        if (!this.isStrictEncoding()) {
            return builder.buildAndExpand(uriVariables).encode();
        }
        Object[] encodedUriVars = new Object[uriVariables.length];
        for (int i = 0; i < uriVariables.length; ++i) {
            encodedUriVars[i] = this.applyStrictEncoding(uriVariables[i]);
        }
        return builder.buildAndExpand(encodedUriVars);
    }

    private String applyStrictEncoding(Object value) {
        String stringValue = value != null ? value.toString() : "";
        return UriUtils.encode(stringValue, "UTF-8");
    }

    private URI createUri(UriComponents uriComponents) {
        try {
            return new URI(uriComponents.toUriString());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not create URI object: " + ex.getMessage(), ex);
        }
    }
}

