/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.retry.policy;

import io.basc.framework.retry.RetryContext;
import io.basc.framework.retry.RetryPolicy;
import io.basc.framework.retry.context.DefaultRetryContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompositeRetryPolicy
implements RetryPolicy {
    RetryPolicy[] policies = new RetryPolicy[0];
    private boolean optimistic = false;

    public void setOptimistic(boolean optimistic) {
        this.optimistic = optimistic;
    }

    public void setPolicies(RetryPolicy[] policies) {
        this.policies = Arrays.asList(policies).toArray(new RetryPolicy[policies.length]);
    }

    @Override
    public boolean canRetry(RetryContext context) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        boolean retryable = true;
        if (this.optimistic) {
            retryable = false;
            for (int i = 0; i < contexts.length; ++i) {
                if (!policies[i].canRetry(contexts[i])) continue;
                retryable = true;
            }
        } else {
            for (int i = 0; i < contexts.length; ++i) {
                if (policies[i].canRetry(contexts[i])) continue;
                retryable = false;
            }
        }
        return retryable;
    }

    @Override
    public void close(RetryContext context) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        RuntimeException exception = null;
        for (int i = 0; i < contexts.length; ++i) {
            try {
                policies[i].close(contexts[i]);
                continue;
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public RetryContext open(RetryContext parent) {
        ArrayList<RetryContext> list = new ArrayList<RetryContext>();
        for (RetryPolicy policy : this.policies) {
            list.add(policy.open(parent));
        }
        return new CompositeRetryContext(parent, list);
    }

    @Override
    public void registerThrowable(RetryContext context, Throwable throwable) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        for (int i = 0; i < contexts.length; ++i) {
            policies[i].registerThrowable(contexts[i], throwable);
        }
        ((DefaultRetryContext)context).setLastThrowable(throwable);
    }

    private class CompositeRetryContext
    extends DefaultRetryContext {
        RetryContext[] contexts;
        RetryPolicy[] policies;

        public CompositeRetryContext(RetryContext parent, List<RetryContext> contexts) {
            super(parent);
            this.contexts = contexts.toArray(new RetryContext[contexts.size()]);
            this.policies = CompositeRetryPolicy.this.policies;
        }
    }
}

