/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.retry.policy;

import io.basc.framework.retry.RetryContext;
import io.basc.framework.retry.RetryPolicy;
import io.basc.framework.retry.context.DefaultRetryContext;
import io.basc.framework.util.ClassUtils;

public class SimpleRetryPolicy
implements RetryPolicy {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private volatile int maxAttempts;

    public SimpleRetryPolicy() {
        this(3);
    }

    public SimpleRetryPolicy(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setMaxAttempts(int retryAttempts) {
        this.maxAttempts = retryAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public boolean canRetry(RetryContext context) {
        return context.getRetryCount() < this.maxAttempts;
    }

    @Override
    public void close(RetryContext status) {
    }

    @Override
    public void registerThrowable(RetryContext context, Throwable throwable) {
        SimpleRetryContext simpleContext = (SimpleRetryContext)context;
        simpleContext.setLastThrowable(throwable);
    }

    @Override
    public RetryContext open(RetryContext parent) {
        return new SimpleRetryContext(parent);
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + "[maxAttempts=" + this.maxAttempts + "]";
    }

    private static class SimpleRetryContext
    extends DefaultRetryContext {
        public SimpleRetryContext(RetryContext parent) {
            super(parent);
        }
    }
}

