/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.retry.policy;

import io.basc.framework.retry.RetryContext;
import io.basc.framework.retry.RetryPolicy;
import io.basc.framework.retry.context.DefaultRetryContext;

public class TimeoutRetryPolicy
implements RetryPolicy {
    public static final long DEFAULT_TIMEOUT = 1000L;
    private long timeout = 1000L;

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean canRetry(RetryContext context) {
        return ((TimeoutRetryContext)context).isAlive();
    }

    @Override
    public void close(RetryContext context) {
    }

    @Override
    public RetryContext open(RetryContext parent) {
        return new TimeoutRetryContext(parent, this.timeout);
    }

    @Override
    public void registerThrowable(RetryContext context, Throwable throwable) {
        ((DefaultRetryContext)context).setLastThrowable(throwable);
    }

    private static class TimeoutRetryContext
    extends DefaultRetryContext {
        private long timeout;
        private long start = System.currentTimeMillis();

        public TimeoutRetryContext(RetryContext parent, long timeout) {
            super(parent);
            this.timeout = timeout;
        }

        public boolean isAlive() {
            return System.currentTimeMillis() - this.start <= this.timeout;
        }
    }
}

