/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.script;

import io.basc.framework.script.ScriptEngine;
import io.basc.framework.script.ScriptException;
import io.basc.framework.script.ScriptResolver;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractScriptEngine<T>
implements ScriptEngine<T> {
    protected final List<ScriptResolver<T>> resolvers = new LinkedList<ScriptResolver<T>>();

    @Override
    public T eval(String script) throws ScriptException {
        for (ScriptResolver<T> resolver : this.getResolvers()) {
            if (!resolver.isSupport(script)) continue;
            return resolver.eval(this, script);
        }
        return this.evalInternal(script);
    }

    public List<ScriptResolver<T>> getResolvers() {
        return this.resolvers;
    }

    protected T evalInternal(String script) throws ScriptException {
        throw new ScriptException(script);
    }
}

