/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.script;

import io.basc.framework.convert.lang.StringConverter;
import io.basc.framework.env.Sys;
import io.basc.framework.mapper.Field;
import io.basc.framework.mapper.FieldFeature;
import io.basc.framework.mapper.Fields;
import io.basc.framework.math.BigDecimalHolder;
import io.basc.framework.math.Calculator;
import io.basc.framework.math.Calculators;
import io.basc.framework.math.NumberHolder;
import io.basc.framework.script.AbstractScriptEngine;
import io.basc.framework.script.MathScriptFunction;
import io.basc.framework.script.ScriptEngine;
import io.basc.framework.script.ScriptException;
import io.basc.framework.script.ScriptResolver;
import io.basc.framework.util.Pair;
import io.basc.framework.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Predicate;

public final class MathScriptEngine
extends AbstractScriptEngine<NumberHolder> {
    static final MathScriptFunction[] FUNCTIONS;

    private void resolve(Collection<Fragment> fragments, String script, Calculator lastOperator) {
        for (MathScriptFunction function : FUNCTIONS) {
            int n;
            String right;
            Pair<Integer, Integer> indexPair = StringUtils.indexOf((CharSequence)script, (CharSequence)function.getPrefix(), function.getSuffix());
            if (indexPair == null) continue;
            int begin = indexPair.getKey();
            int end = indexPair.getValue();
            int prefixLength = function.getPrefix().length();
            int suffixLength = function.getSuffix().length();
            int scriptLength = script.length();
            String left = begin == 0 ? null : script.substring(0, begin);
            String center = script.substring(begin + prefixLength, end - suffixLength + 1);
            String string = right = end == scriptLength - suffixLength ? null : script.substring(end + suffixLength, scriptLength);
            if (left != null) {
                Calculator leftOperator = null;
                Calculator[][] calculatorArray = Calculators.GROUPS;
                int n2 = calculatorArray.length;
                block1: for (n = 0; n < n2; ++n) {
                    Calculator[] operators;
                    for (Calculator operator : operators = calculatorArray[n]) {
                        if (!left.endsWith(operator.getOperator())) continue;
                        leftOperator = operator;
                        continue block1;
                    }
                }
                if (leftOperator == null) {
                    throw new ScriptException(script);
                }
                left = left.substring(0, left.length() - leftOperator.getOperator().length());
                this.resolve(fragments, left, leftOperator);
            }
            Calculator centerOperator = null;
            if (right != null) {
                Calculator rightOperator = null;
                Calculator[][] calculatorArray = Calculators.GROUPS;
                n = calculatorArray.length;
                block3: for (int i = 0; i < n; ++i) {
                    Calculator[] operators;
                    for (Calculator operator : operators = calculatorArray[i]) {
                        if (!right.startsWith(operator.getOperator())) continue;
                        rightOperator = operator;
                        continue block3;
                    }
                }
                if (rightOperator == null) {
                    throw new ScriptException(script);
                }
                right = right.substring(rightOperator.getOperator().length());
                centerOperator = rightOperator;
            }
            ValueFragment centerFragment = new ValueFragment(function.eval(this, center));
            if (centerOperator != null) {
                centerFragment.setOperator(centerOperator);
                fragments.add(centerFragment);
            } else {
                centerFragment.setOperator(lastOperator);
                fragments.add(centerFragment);
            }
            if (right != null) {
                this.resolve(fragments, right, lastOperator);
            }
            return;
        }
        MathScriptFunction[] mathScriptFunctionArray = Calculators.GROUPS;
        int n = mathScriptFunctionArray.length;
        for (int i = 0; i < n; ++i) {
            MathScriptFunction operators;
            for (MathScriptFunction operator : operators = mathScriptFunctionArray[i]) {
                int index = script.indexOf(operator.getOperator());
                if (index == -1) continue;
                String s = script.substring(0, index);
                this.resolve(fragments, s, (Calculator)((Object)operator));
                String right = script.substring(index + operator.getOperator().length());
                if (StringUtils.isNotEmpty(right)) {
                    this.resolve(fragments, right, lastOperator);
                }
                return;
            }
        }
        fragments.add(new ScriptFragment(script).setOperator(lastOperator));
    }

    private Fragment operator(Fragment left, Fragment right) {
        NumberHolder value = (NumberHolder)left.getOperator().eval(left.getValue(), right.getValue());
        ValueFragment valueFragment = new ValueFragment(value);
        valueFragment.setOperator(right.getOperator());
        return valueFragment;
    }

    private int indexOf(Calculator operator, Collection<Fragment> fragments) {
        Iterator<Fragment> iterator = fragments.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Fragment fragment = iterator.next();
            if (iterator.hasNext() && fragment.getOperator().getOperator().equals(operator.getOperator())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private NumberHolder eval(Collection<Fragment> fragments) {
        if (fragments == null || fragments.isEmpty()) {
            return null;
        }
        for (Calculator[] operators : Calculators.GROUPS) {
            int indexToUse = -1;
            for (Calculator operator : operators) {
                int index = this.indexOf(operator, fragments);
                if (index == -1 || indexToUse != -1 && index >= indexToUse) continue;
                indexToUse = index;
            }
            if (indexToUse == -1) continue;
            LinkedList<Fragment> nextFragments = new LinkedList<Fragment>();
            int index = 0;
            Iterator<Fragment> iterator = fragments.iterator();
            while (iterator.hasNext()) {
                Fragment fragment = iterator.next();
                if (index == indexToUse) {
                    Fragment value = this.operator(fragment, iterator.next());
                    nextFragments.add(value);
                } else {
                    nextFragments.add(fragment);
                }
                ++index;
            }
            if (nextFragments.size() == fragments.size()) continue;
            return this.eval(nextFragments);
        }
        if (fragments.size() == 1) {
            return fragments.iterator().next().getValue();
        }
        throw new RuntimeException("Should never get here");
    }

    @Override
    public NumberHolder eval(String script) {
        String scriptToUse = StringUtils.trimAllWhitespace(script);
        if (StringUtils.isEmpty(scriptToUse)) {
            return null;
        }
        if (StringConverter.DEFAULT.getStringToNumber().isNumeric(scriptToUse)) {
            return new BigDecimalHolder(scriptToUse);
        }
        return (NumberHolder)super.eval(scriptToUse);
    }

    @Override
    protected NumberHolder evalInternal(String script) throws ScriptException {
        String s;
        Fragment fragment;
        for (MathScriptFunction function : FUNCTIONS) {
            Pair<Integer, Integer> indexPair = StringUtils.indexOf((CharSequence)script, (CharSequence)function.getPrefix(), function.getSuffix());
            if (indexPair == null || indexPair.getKey() != 0 || indexPair.getValue() != script.length() - 1) continue;
            String scriptToUse = script.substring(function.getPrefix().length(), script.length() - function.getSuffix().length());
            return function.eval(this, scriptToUse);
        }
        LinkedList<Fragment> fragments = new LinkedList<Fragment>();
        this.resolve(fragments, script, null);
        if (fragments.isEmpty()) {
            return (NumberHolder)super.evalInternal(script);
        }
        if (fragments.size() == 1 && (fragment = fragments.get(0)) instanceof ScriptFragment && (s = ((ScriptFragment)fragment).script).equals(script)) {
            return (NumberHolder)super.evalInternal(script);
        }
        return this.eval(fragments);
    }

    static {
        ArrayList<MathScriptFunction> functions = new ArrayList<MathScriptFunction>(Sys.getEnv().getServiceLoader(MathScriptFunction.class).toList());
        functions.add(new MaxFunction());
        functions.add(new MinFunction());
        functions.add(new MeaninglessFunction("{", "}"));
        functions.add(new MeaninglessFunction("[", "]"));
        functions.add(new MeaninglessFunction("(", ")"));
        functions.add(new AbsoluteValueFunction());
        FUNCTIONS = functions.toArray(new MathScriptFunction[0]);
    }

    static final class MinFunction
    implements MathScriptFunction {
        MinFunction() {
        }

        @Override
        public String getPrefix() {
            return "min(";
        }

        @Override
        public String getSuffix() {
            return ")";
        }

        @Override
        public NumberHolder eval(ScriptEngine<NumberHolder> engine, String script) throws ScriptException {
            NumberHolder rightValue;
            int index = script.indexOf(",");
            if (index == -1) {
                throw new ScriptException(script);
            }
            String left = script.substring(0, index);
            String right = script.substring(index + 1);
            NumberHolder leftValue = engine.eval(left);
            return leftValue.compareTo(rightValue = engine.eval(right)) < 0 ? leftValue : rightValue;
        }
    }

    static final class MaxFunction
    implements MathScriptFunction {
        MaxFunction() {
        }

        @Override
        public String getPrefix() {
            return "max(";
        }

        @Override
        public String getSuffix() {
            return ")";
        }

        @Override
        public NumberHolder eval(ScriptEngine<NumberHolder> engine, String script) throws ScriptException {
            NumberHolder rightValue;
            int index = script.indexOf(",");
            if (index == -1) {
                throw new ScriptException(script);
            }
            String left = script.substring(0, index);
            String right = script.substring(index + 1);
            NumberHolder leftValue = engine.eval(left);
            return leftValue.compareTo(rightValue = engine.eval(right)) > 0 ? leftValue : rightValue;
        }
    }

    static final class AbsoluteValueFunction
    implements MathScriptFunction {
        AbsoluteValueFunction() {
        }

        @Override
        public String getPrefix() {
            return "|";
        }

        @Override
        public String getSuffix() {
            return "|";
        }

        @Override
        public NumberHolder eval(ScriptEngine<NumberHolder> engine, String script) throws ScriptException {
            NumberHolder value = engine.eval(script);
            return value.abs();
        }
    }

    static final class MeaninglessFunction
    implements MathScriptFunction {
        private String prefix;
        private String suffix;

        public MeaninglessFunction(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public NumberHolder eval(ScriptEngine<NumberHolder> engine, String script) throws ScriptException {
            return engine.eval(script);
        }
    }

    final class ValueFragment
    extends Fragment {
        private final NumberHolder value;

        public ValueFragment(NumberHolder value) {
            this.value = value;
        }

        @Override
        public NumberHolder getValue() {
            return this.value;
        }

        public String toString() {
            return "(" + (this.value == null ? null : this.value.toString()) + ")" + (this.getOperator() == null ? "" : this.getOperator().getOperator());
        }
    }

    final class ScriptFragment
    extends Fragment {
        private final String script;

        public ScriptFragment(String script) {
            this.script = script;
        }

        @Override
        public NumberHolder getValue() {
            return MathScriptEngine.this.eval(this.script);
        }

        public String toString() {
            return "(" + this.script + ")" + (this.getOperator() == null ? "" : this.getOperator().getOperator());
        }
    }

    abstract class Fragment {
        private Calculator operator;

        Fragment() {
        }

        public abstract NumberHolder getValue();

        public Calculator getOperator() {
            return this.operator;
        }

        public Fragment setOperator(Calculator operator) {
            this.operator = operator;
            return this;
        }
    }

    public static final class ObjectFieldScriptResolver
    implements ScriptResolver<NumberHolder> {
        private Object instance;
        private Fields fields;

        public ObjectFieldScriptResolver(Object instance) {
            this.instance = instance;
            this.fields = instance == null ? null : (Fields)((Fields)((Fields)Fields.getFields(instance.getClass()).all()).filter((Predicate)FieldFeature.SUPPORT_GETTER)).shared();
        }

        @Override
        public boolean isSupport(String script) {
            if (this.instance == null) {
                return false;
            }
            return this.getField(script) != null;
        }

        public Field getField(String name) {
            return this.fields == null ? null : (Field)this.fields.getByName(name, null);
        }

        @Override
        public NumberHolder eval(ScriptEngine<NumberHolder> engine, String script) throws ScriptException {
            Field field = this.getField(script);
            Object value = field.get(this.instance);
            if (value == null) {
                throw new ScriptException(script);
            }
            if (value instanceof BigDecimal) {
                return new BigDecimalHolder((BigDecimal)value);
            }
            if (value instanceof NumberHolder) {
                return (NumberHolder)value;
            }
            return new BigDecimalHolder(value.toString());
        }
    }
}

