/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.MultiValueMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMultiValueMap<K, V>
implements MultiValueMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    protected abstract Map<K, List<V>> getTargetMap();

    protected List<V> createList() {
        return new ArrayList(8);
    }

    @Override
    public void add(K key, V value) {
        List<V> values = this.getTargetMap().get(key);
        if (values == null) {
            values = this.createList();
            this.getTargetMap().put(key, values);
        }
        values.add(value);
    }

    @Override
    public V getFirst(K key) {
        List<V> values = this.getTargetMap().get(key);
        return values != null ? (V)values.get(0) : null;
    }

    @Override
    public void set(K key, V value) {
        List<V> values = this.createList();
        values.add(value);
        this.getTargetMap().put(key, values);
    }

    @Override
    public void setAll(Map<K, V> values) {
        for (Map.Entry<K, V> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.getTargetMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getTargetMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getTargetMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getTargetMap().containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return this.getTargetMap().get(key);
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.getTargetMap().put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return this.getTargetMap().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> m) {
        this.getTargetMap().putAll(m);
    }

    @Override
    public void clear() {
        this.getTargetMap().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.getTargetMap().keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.getTargetMap().values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.getTargetMap().entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.getTargetMap().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getTargetMap().hashCode();
    }

    public String toString() {
        return this.getTargetMap().toString();
    }
}

