/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.AbstractOptional;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.DefaultOptional;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Bound<T>
extends DefaultOptional<T> {
    private static final long serialVersionUID = 1L;
    private static final Bound<?> UNBOUNDED = new Bound<Object>(null, true);
    private final boolean inclusive;

    private Bound(T value, boolean inclusive) {
        super(value);
        this.inclusive = inclusive;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    @Override
    public <U> Bound<U> convert(Function<? super T, ? extends U> converter) {
        return new Bound<U>(converter.apply(this.getValue()), this.inclusive);
    }

    @Override
    public <U> Bound<U> map(Function<? super T, ? extends U> mapper) {
        return this.convert((T e) -> e == null ? null : mapper.apply(e));
    }

    @Override
    public Bound<T> filter(Predicate<? super T> predicate) {
        return this.convert((T e) -> e != null && predicate.test(e) ? e : null);
    }

    public static <T> Bound<T> unbounded() {
        return UNBOUNDED;
    }

    public boolean isBounded() {
        return this.isPresent();
    }

    public static <T> Bound<T> inclusive(T value) {
        Assert.notNull(value, "Value must not be null!");
        return new Bound<T>(value, true);
    }

    public static Bound<Integer> inclusive(int value) {
        return Bound.inclusive(Integer.valueOf(value));
    }

    public static Bound<Long> inclusive(long value) {
        return Bound.inclusive(Long.valueOf(value));
    }

    public static Bound<Float> inclusive(float value) {
        return Bound.inclusive(Float.valueOf(value));
    }

    public static Bound<Double> inclusive(double value) {
        return Bound.inclusive(Double.valueOf(value));
    }

    public static <T> Bound<T> exclusive(T value) {
        Assert.notNull(value, "Value must not be null!");
        return new Bound<T>(value, false);
    }

    public static Bound<Integer> exclusive(int value) {
        return Bound.exclusive(Integer.valueOf(value));
    }

    public static Bound<Long> exclusive(long value) {
        return Bound.exclusive(Long.valueOf(value));
    }

    public static Bound<Float> exclusive(float value) {
        return Bound.exclusive(Float.valueOf(value));
    }

    public static Bound<Double> exclusive(double value) {
        return Bound.exclusive(Double.valueOf(value));
    }

    @Override
    public String toString() {
        return ((AbstractOptional)this.map(Object::toString)).orElse("unbounded");
    }

    @Override
    public int hashCode() {
        return CollectionUtils.hashCode(Arrays.asList(this.inclusive, super.hashCode()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Bound) {
            Bound other = (Bound)obj;
            return this.inclusive == other.inclusive && super.equals(obj);
        }
        return false;
    }
}

