/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.Source;
import io.basc.framework.util.StaticSupplier;
import java.util.function.Supplier;

public class CacheableSource<T, E extends Throwable>
implements Source<T, E> {
    private Source<? extends T, ? extends E> source;
    private Object lock;
    private volatile Supplier<T> caching;

    public CacheableSource(T source) {
        this.caching = new StaticSupplier<T>(source);
    }

    public CacheableSource(Source<? extends T, ? extends E> source, @Nullable Object lock) {
        Assert.requiredArgument(source != null, "source");
        this.lock = lock;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws E {
        if (this.caching == null && this.source != null) {
            Object object = this.lock == null ? this : this.lock;
            synchronized (object) {
                if (this.caching == null) {
                    T value = this.source.get();
                    this.caching = new StaticSupplier<T>(value);
                }
            }
        }
        return this.caching.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws E {
        if (this.caching != null && this.source != null) {
            Object object = this.lock == null ? this : this.lock;
            synchronized (object) {
                if (this.caching != null) {
                    this.caching = new StaticSupplier<T>(this.source.get());
                }
            }
        }
    }

    public String toString() {
        return this.caching == null ? this.source.toString() : this.caching.toString();
    }

    public int hashCode() {
        return this.caching == null ? this.source.hashCode() : this.caching.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CacheableSource) {
            CacheableSource other = (CacheableSource)obj;
            if (this.caching != null && other.caching != null && ObjectUtils.equals(this.caching, other.caching)) {
                return true;
            }
            return ObjectUtils.equals(this.source, other.source);
        }
        return false;
    }
}

