/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.CharSequenceSplitSegment;
import io.basc.framework.util.Pair;
import io.basc.framework.util.StaticSupplier;
import io.basc.framework.util.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class CharSequenceSplitIterator
implements Iterator<CharSequenceSplitSegment> {
    private final CharSequence charSequence;
    private final Collection<? extends CharSequence> filters;
    private final int endIndex;
    private int index;
    private Supplier<Pair<Integer, CharSequence>> current;

    public CharSequenceSplitIterator(CharSequence charSequence, Collection<? extends CharSequence> filters, int beginIndex, int endIndex) {
        this.charSequence = charSequence;
        this.filters = filters;
        this.index = beginIndex;
        this.endIndex = endIndex;
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.endIndex) {
            return false;
        }
        if (this.current == null) {
            for (CharSequence charSequence : this.filters) {
                int index;
                if (charSequence == null || (index = StringUtils.indexOf(this.charSequence, charSequence, this.index, this.endIndex)) == -1) continue;
                this.current = new StaticSupplier<Pair<Integer, CharSequence>>(new Pair<Integer, CharSequence>(index, charSequence));
                break;
            }
        }
        if (this.current == null) {
            return this.index < this.endIndex;
        }
        return true;
    }

    @Override
    public CharSequenceSplitSegment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.current == null) {
            CharSequence value = this.index == 0 ? this.charSequence : this.charSequence.subSequence(this.index, this.endIndex);
            this.index = this.endIndex;
            return new CharSequenceSplitSegment(value);
        }
        CharSequence value = this.charSequence.subSequence(this.index, this.current.get().getKey());
        this.index = this.current.get().getKey() + this.current.get().getValue().length();
        CharSequenceSplitSegment pair = new CharSequenceSplitSegment(value, this.current.get().getValue());
        this.current = null;
        return pair;
    }
}

