/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.StringUtils;
import java.util.function.Function;

public class CharSequenceSplitSegment
implements CharSequence {
    private final CharSequence source;
    @Nullable
    private final CharSequence separator;

    public CharSequenceSplitSegment(CharSequence source) {
        this(source, null);
    }

    public CharSequenceSplitSegment(CharSequence source, @Nullable CharSequence separator) {
        Assert.requiredArgument(source != null, "source");
        this.source = source;
        this.separator = separator;
    }

    public boolean isLast() {
        return this.separator == null;
    }

    public CharSequence getSource() {
        return this.source;
    }

    @Nullable
    public CharSequence getSeparator() {
        return this.separator;
    }

    @Override
    public int length() {
        return this.source.length();
    }

    @Override
    public boolean isEmpty() {
        return this.source.length() == 0;
    }

    public CharSequenceSplitSegment trim() {
        return new CharSequenceSplitSegment(StringUtils.trimWhitespace(this.source), this.separator);
    }

    public CharSequenceSplitSegment map(Function<CharSequence, CharSequence> mapper) {
        return new CharSequenceSplitSegment(mapper.apply(this.source), this.separator);
    }

    @Override
    public char charAt(int index) {
        return this.source.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.source.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.source.toString();
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof CharSequenceSplitSegment) {
            return ObjectUtils.equals(this.source, ((CharSequenceSplitSegment)obj).source);
        }
        return false;
    }
}

