/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.LinkedMultiValueMap;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.Processor;
import io.basc.framework.util.SortedProperties;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public final class CollectionFactory {
    private static final Field KEY_TYPE_FIELD = ReflectionUtils.getDeclaredField(EnumMap.class, "keyType");
    private static final Field ELEMENT_TYPE_FIELD = ReflectionUtils.getDeclaredField(EnumSet.class, "elementType");
    private static final Set<Class<?>> approximableCollectionTypes = new HashSet();
    private static final Set<Class<?>> approximableMapTypes = new HashSet();

    private CollectionFactory() {
    }

    public static boolean isApproximableCollectionType(@Nullable Class<?> collectionType) {
        return collectionType != null && approximableCollectionTypes.contains(collectionType);
    }

    public static <E> Collection<E> createApproximateCollection(@Nullable Object collection, int capacity) {
        if (collection instanceof LinkedList) {
            return new LinkedList();
        }
        if (collection instanceof List) {
            return new ArrayList(capacity);
        }
        if (collection instanceof EnumSet) {
            EnumSet enumSet = EnumSet.copyOf((EnumSet)collection);
            enumSet.clear();
            return enumSet;
        }
        if (collection instanceof SortedSet) {
            return new TreeSet(((SortedSet)collection).comparator());
        }
        return new LinkedHashSet(capacity);
    }

    public static <E> Collection<E> createCollection(Class<?> collectionType, int capacity) {
        return CollectionFactory.createCollection(collectionType, null, capacity);
    }

    public static <E> Collection<E> createCollection(Class<?> collectionType, @Nullable Class<?> elementType, int capacity) throws IllegalArgumentException {
        Assert.notNull(collectionType, "Collection type must not be null");
        if (collectionType.isInterface()) {
            if (Set.class == collectionType || Collection.class == collectionType) {
                if (capacity == 0) {
                    return Collections.emptySet();
                }
                return new LinkedHashSet(capacity);
            }
            if (List.class == collectionType) {
                if (capacity == 0) {
                    return Collections.emptyList();
                }
                return new ArrayList(capacity);
            }
            if (SortedSet.class == collectionType) {
                if (capacity == 0) {
                    return Collections.emptySortedSet();
                }
                return new TreeSet();
            }
            if (NavigableSet.class == collectionType) {
                if (capacity == 0) {
                    return Collections.emptyNavigableSet();
                }
                return new TreeSet();
            }
            throw new IllegalArgumentException("Unsupported Collection interface: " + collectionType.getName());
        }
        if (EnumSet.class.isAssignableFrom(collectionType)) {
            Assert.notNull(elementType, "Cannot create EnumSet for unknown element type");
            return EnumSet.noneOf(CollectionFactory.asEnumType(elementType));
        }
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Unsupported Collection type: " + collectionType.getName());
        }
        try {
            return (Collection)ReflectionUtils.newInstance(collectionType);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Could not instantiate Collection type: " + collectionType.getName(), ex);
        }
    }

    public static boolean isApproximableMapType(@Nullable Class<?> mapType) {
        return mapType != null && approximableMapTypes.contains(mapType);
    }

    public static <K, V> Map<K, V> createApproximateMap(@Nullable Object map, int capacity) {
        if (map instanceof EnumMap) {
            EnumMap enumMap = new EnumMap((EnumMap)map);
            enumMap.clear();
            return enumMap;
        }
        if (map instanceof SortedMap) {
            return new TreeMap(((SortedMap)map).comparator());
        }
        return new LinkedHashMap(capacity);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, int capacity) {
        return CollectionFactory.createMap(mapType, null, capacity);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, @Nullable Class<?> keyType, int capacity) {
        Assert.notNull(mapType, "Map type must not be null");
        if (mapType.isInterface()) {
            if (Map.class == mapType) {
                if (capacity == 0) {
                    return Collections.emptyMap();
                }
                return new LinkedHashMap(capacity);
            }
            if (SortedMap.class == mapType) {
                if (capacity == 0) {
                    return Collections.emptySortedMap();
                }
                return new TreeMap();
            }
            if (NavigableMap.class == mapType) {
                if (capacity == 0) {
                    return Collections.emptyNavigableMap();
                }
                return new TreeMap();
            }
            if (MultiValueMap.class == mapType) {
                if (capacity == 0) {
                    return CollectionUtils.emptyMultiValueMap();
                }
                return new LinkedMultiValueMap(capacity);
            }
            throw new IllegalArgumentException("Unsupported Map interface: " + mapType.getName());
        }
        if (EnumMap.class == mapType) {
            Assert.notNull(keyType, "Cannot create EnumMap for unknown key type");
            return new EnumMap(CollectionFactory.asEnumType(keyType));
        }
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Unsupported Map type: " + mapType.getName());
        }
        try {
            return (Map)ReflectionUtils.newInstance(mapType);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Could not instantiate Map type: " + mapType.getName(), ex);
        }
    }

    public static Properties createStringAdaptingProperties() {
        return new SortedProperties(false){

            @Override
            @Nullable
            public String getProperty(String key) {
                Object value = this.get(key);
                return value != null ? value.toString() : null;
            }
        };
    }

    public static Properties createSortedProperties(boolean omitComments) {
        return new SortedProperties(omitComments);
    }

    public static Properties createSortedProperties(Properties properties, boolean omitComments) {
        return new SortedProperties(properties, omitComments);
    }

    private static Class<? extends Enum> asEnumType(Class<?> enumType) {
        Assert.notNull(enumType, "Enum type must not be null");
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new IllegalArgumentException("Supplied type is not an enum: " + enumType.getName());
        }
        return enumType.asSubclass(Enum.class);
    }

    public static <E> List<E> createArrayList(boolean concurrent) {
        return CollectionFactory.createArrayList(concurrent, 16);
    }

    public static <E> List<E> createArrayList(boolean concurrent, int initialCapacity) {
        return concurrent ? new CopyOnWriteArrayList() : new ArrayList(initialCapacity);
    }

    public static <E> Set<E> createSet(boolean concurrent) {
        return concurrent ? new CopyOnWriteArraySet() : new LinkedHashSet();
    }

    public static <E> Set<E> createSet(boolean concurrent, int initialCapacity) {
        return concurrent ? new CopyOnWriteArraySet() : new LinkedHashSet(initialCapacity);
    }

    public static <T> Class<T> getEnumMapKeyType(Map map) {
        Class keyType = null;
        if (map instanceof EnumMap) {
            keyType = (Class)ReflectionUtils.get(KEY_TYPE_FIELD, map);
        }
        return keyType;
    }

    public static <M extends Map<K, V>, K, V> M clone(M map) {
        Assert.requiredArgument(map != null, "map");
        return CollectionFactory.clone(map, false);
    }

    public static <M extends Map<K, V>, K, V> M clone(M map, boolean deep) {
        Map<K, V> cloneMap;
        Assert.requiredArgument(map != null, "map");
        if (!deep) {
            Map m = (Map)ReflectionUtils.invokeCloneMethod(map);
            if (m != null) {
                return (M)m;
            }
            return (M)ReflectionUtils.clone(m);
        }
        Class<?> mapType = map.getClass();
        if (mapType == TreeMap.class) {
            cloneMap = new TreeMap(((TreeMap)map).comparator());
        } else {
            try {
                cloneMap = CollectionFactory.createMap(map.getClass(), CollectionFactory.getEnumMapKeyType(map), map.size());
            }
            catch (Exception e2) {
                return ReflectionUtils.clone(map, deep);
            }
        }
        ReflectionUtils.clone(ReflectionUtils.getDeclaredFields(mapType).withAll(e -> e != Object.class && (!e.getName().startsWith("java.util.") || !e.getName().endsWith("Map"))), map, cloneMap, deep);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            cloneMap.put(ObjectUtils.clone(entry.getKey(), deep), ObjectUtils.clone(entry.getValue(), deep));
        }
        return (M)cloneMap;
    }

    public static <T> Class<T> getEnumSetElementType(Collection collection) {
        Class elementType = null;
        if (collection instanceof EnumSet) {
            elementType = (Class)ReflectionUtils.get(ELEMENT_TYPE_FIELD, collection);
        }
        return elementType;
    }

    public static <C extends Collection<E>, E> C clone(C collection) {
        return CollectionFactory.clone(collection, false);
    }

    public static <C extends Collection<E>, E> C clone(C collection, boolean deep) {
        Collection<E> cloneCollection;
        Assert.requiredArgument(collection != null, "collection");
        if (!deep) {
            Collection value = (Collection)ReflectionUtils.invokeCloneMethod(collection);
            if (value != null) {
                return (C)value;
            }
            return ReflectionUtils.clone(collection);
        }
        Class<?> collectionClass = collection.getClass();
        if (collectionClass == TreeSet.class) {
            cloneCollection = new TreeSet(((TreeSet)collection).comparator());
        } else {
            try {
                cloneCollection = CollectionFactory.createCollection(collection.getClass(), CollectionFactory.getEnumSetElementType(collection), collection.size());
            }
            catch (IllegalArgumentException e2) {
                return ReflectionUtils.clone(collection, deep);
            }
        }
        ReflectionUtils.clone(ReflectionUtils.getDeclaredFields(collectionClass).withAll(e -> e != Object.class && (!e.getName().startsWith("java.util.") || !e.getName().endsWith("Set") && !e.getName().endsWith("List"))), collection, cloneCollection, deep);
        for (E e3 : collection) {
            cloneCollection.add(ObjectUtils.clone(e3, deep));
        }
        return (C)cloneCollection;
    }

    public static <K, V, SK, SV, E extends Throwable> Map<K, V> convert(Map<? extends SK, ? extends SV> sourceMap, Processor<? super SK, ? extends K, ? extends E> keyConverter, Processor<? super SV, ? extends V, ? extends E> valueConverter) throws E {
        if (CollectionUtils.isEmpty(sourceMap)) {
            return Collections.emptyMap();
        }
        Map<K, V> targetMap = CollectionFactory.createMap(sourceMap.getClass(), CollectionFactory.getEnumMapKeyType(sourceMap), sourceMap.size());
        for (Map.Entry<SK, SV> entry : sourceMap.entrySet()) {
            K key = keyConverter.process(entry.getKey());
            V value = valueConverter.process(entry.getValue());
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static <T> T empty(Class<?> type) {
        if (Map.class.isAssignableFrom(type)) {
            return (T)Collections.emptyNavigableMap();
        }
        if (Set.class.isAssignableFrom(type)) {
            return (T)Collections.emptyNavigableSet();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return (T)Collections.emptyList();
        }
        throw new IllegalArgumentException("Unsupported Collection type: " + type);
    }

    static {
        ReflectionUtils.makeAccessible(KEY_TYPE_FIELD);
        ReflectionUtils.makeAccessible(ELEMENT_TYPE_FIELD);
        approximableCollectionTypes.add(Collection.class);
        approximableCollectionTypes.add(List.class);
        approximableCollectionTypes.add(Set.class);
        approximableCollectionTypes.add(SortedSet.class);
        approximableCollectionTypes.add(NavigableSet.class);
        approximableMapTypes.add(Map.class);
        approximableMapTypes.add(SortedMap.class);
        approximableMapTypes.add(NavigableMap.class);
        approximableCollectionTypes.add(ArrayList.class);
        approximableCollectionTypes.add(LinkedList.class);
        approximableCollectionTypes.add(HashSet.class);
        approximableCollectionTypes.add(LinkedHashSet.class);
        approximableCollectionTypes.add(TreeSet.class);
        approximableCollectionTypes.add(EnumSet.class);
        approximableMapTypes.add(HashMap.class);
        approximableMapTypes.add(LinkedHashMap.class);
        approximableMapTypes.add(TreeMap.class);
        approximableMapTypes.add(EnumMap.class);
    }
}

