/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.IterationIterator;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.MultiValueMapWrapper;
import io.basc.framework.util.ObjectUtils;
import io.basc.framework.util.XUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public abstract class CollectionUtils {
    private static final MultiValueMap EMPTY_MULTI_VALUE_MAP = new MultiValueMapWrapper(Collections.emptyMap());

    public static List arrayToList(Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray(source));
    }

    public static <T> int compare(Collection<? extends T> collection1, Collection<? extends T> collection2, Comparator<T> comparator) {
        if (CollectionUtils.isEmpty(collection1)) {
            return CollectionUtils.isEmpty(collection2) ? 0 : -1;
        }
        if (CollectionUtils.isEmpty(collection2)) {
            return CollectionUtils.isEmpty(collection1) ? 0 : 1;
        }
        Iterator<T> iterator1 = collection1.iterator();
        Iterator<T> iterator2 = collection2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            int v = comparator.compare(iterator1.next(), iterator2.next());
            if (v == 0) continue;
            return v;
        }
        return collection1.size() - collection2.size();
    }

    public static <T> int compare(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2, Comparator<T> comparator) {
        if (CollectionUtils.isEmpty(iterator1)) {
            return CollectionUtils.isEmpty(iterator2) ? 0 : -1;
        }
        if (CollectionUtils.isEmpty(iterator2)) {
            return CollectionUtils.isEmpty(iterator1) ? 0 : 1;
        }
        while (iterator1.hasNext() && iterator2.hasNext()) {
            int v = comparator.compare(iterator1.next(), iterator2.next());
            if (v == 0) continue;
            return v;
        }
        return iterator1.hasNext() ? 1 : (iterator2.hasNext() ? -1 : 0);
    }

    public static <E> Collection<E> complementary(Iterable<? extends E> universal, Iterable<? extends E> subaggregate) {
        if (CollectionUtils.isEmpty(universal)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(subaggregate)) {
            return XUtils.stream(universal.iterator()).collect(Collectors.toList());
        }
        if (universal instanceof Set) {
            LinkedHashSet universalSet = new LinkedHashSet();
            universal.forEach(universalSet::add);
            subaggregate.forEach(universalSet::remove);
            return universalSet;
        }
        return CollectionUtils.complementary(universal.iterator(), subaggregate.iterator());
    }

    public static <E> Collection<E> complementary(Iterable<? extends E> universal, Iterable<? extends E> subaggregate, Comparator<? super E> comparator) {
        if (CollectionUtils.isEmpty(universal)) {
            return Collections.emptyList();
        }
        return CollectionUtils.complementary(universal.iterator(), subaggregate == null ? Collections.emptyIterator() : subaggregate.iterator(), comparator);
    }

    public static <E> Collection<E> complementary(Iterator<? extends E> universal, Iterator<? extends E> subaggregate) {
        return CollectionUtils.complementary(universal, subaggregate, (o1, o2) -> ObjectUtils.equals(o1, o2) ? 0 : 1);
    }

    public static <E> List<E> complementary(Iterator<? extends E> universal, Iterator<? extends E> subaggregate, Comparator<? super E> comparator) {
        Assert.requiredArgument(comparator != null, "comparator");
        if (CollectionUtils.isEmpty(universal)) {
            return Collections.emptyList();
        }
        ArrayList universalSet = new ArrayList();
        universal.forEachRemaining(universalSet::add);
        if (CollectionUtils.isEmpty(subaggregate)) {
            return universalSet;
        }
        block0: while (subaggregate.hasNext()) {
            E element = subaggregate.next();
            Iterator iterator = universalSet.iterator();
            while (iterator.hasNext()) {
                Object source = iterator.next();
                if (comparator.compare(source, element) != 0) continue;
                iterator.remove();
                continue block0;
            }
        }
        return universalSet;
    }

    public static boolean containsAny(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsInstance(Collection collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <K, V> MultiValueMap<K, V> emptyMultiValueMap() {
        return EMPTY_MULTI_VALUE_MAP;
    }

    public static <E> boolean equals(Iterable<? extends E> leftIterable, Iterable<? extends E> rightIterable) {
        return CollectionUtils.equals(leftIterable, rightIterable, (o1, o2) -> ObjectUtils.equals(o1, o2) ? 0 : 1);
    }

    public static <E> boolean equals(Iterable<? extends E> leftIterable, Iterable<? extends E> rightIterable, Comparator<? super E> comparator) {
        if (CollectionUtils.isEmpty(leftIterable)) {
            return CollectionUtils.isEmpty(rightIterable);
        }
        if (CollectionUtils.isEmpty(rightIterable)) {
            return CollectionUtils.isEmpty(leftIterable);
        }
        return CollectionUtils.equals(leftIterable.iterator(), rightIterable.iterator(), comparator);
    }

    public static <E> boolean equals(Iterator<? extends E> leftIterator, Iterator<? extends E> rightIterator) {
        return CollectionUtils.equals(leftIterator, rightIterator, (o1, o2) -> ObjectUtils.equals(o1, o2) ? 0 : 1);
    }

    public static <E> boolean equals(Iterator<? extends E> leftIterator, Iterator<? extends E> rightIterator, Comparator<? super E> comparator) {
        Assert.requiredArgument(comparator != null, "comparator");
        if (CollectionUtils.isEmpty(leftIterator)) {
            return CollectionUtils.isEmpty(rightIterator);
        }
        if (CollectionUtils.isEmpty(rightIterator)) {
            return CollectionUtils.isEmpty(leftIterator);
        }
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            if (comparator.compare(leftIterator.next(), rightIterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public static Class<?> findCommonElementType(Collection collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class<?> candidate = null;
        for (Object val : collection) {
            if (val == null) continue;
            if (candidate == null) {
                candidate = val.getClass();
                continue;
            }
            if (candidate == val.getClass()) continue;
            return null;
        }
        return candidate;
    }

    public static Object findFirstMatch(Collection source, Collection candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?>[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        for (Class<?> type : types) {
            Object value = CollectionUtils.findValueOfType(collection, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static <T> T findValueOfType(Collection<?> collection, Class<T> type) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        T value = null;
        for (Object element : collection) {
            if (type != null && !type.isInstance(element)) continue;
            if (value != null) {
                return null;
            }
            value = (T)element;
        }
        return value;
    }

    public static <E> Iterator<E> getIterator(List<E> list, boolean previous) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyIterator();
        }
        if (previous) {
            return new PreviousIterator<E>(list.listIterator(list.size()));
        }
        return list.iterator();
    }

    public static <E> int hashCode(Iterable<? extends E> iterable) {
        return CollectionUtils.hashCode(iterable, (? super E e) -> e.hashCode());
    }

    public static <E> int hashCode(Iterable<? extends E> iterable, ToIntFunction<? super E> hash) {
        if (iterable == null) {
            return 0;
        }
        return CollectionUtils.hashCode(iterable.iterator(), hash);
    }

    public static <E> int hashCode(Iterator<? extends E> iterator) {
        return CollectionUtils.hashCode(iterator, (? super E e) -> e.hashCode());
    }

    public static <E> int hashCode(Iterator<? extends E> iterator, ToIntFunction<? super E> hash) {
        if (iterator == null) {
            return 0;
        }
        int result = 1;
        while (iterator.hasNext()) {
            E element = iterator.next();
            result = 31 * result + (element == null ? 0 : hash.applyAsInt(element));
        }
        return result;
    }

    public static <E> Collection<E> intersection(Iterable<? extends E> leftIterable, Iterable<? extends E> rightIterable) {
        if (CollectionUtils.isEmpty(leftIterable) || CollectionUtils.isEmpty(rightIterable)) {
            return Collections.emptyList();
        }
        if (rightIterable instanceof Set) {
            LinkedHashSet rightSet = new LinkedHashSet();
            rightIterable.forEach(rightSet::add);
            ArrayList<E> list = null;
            for (E left : leftIterable) {
                if (!rightSet.remove(left)) continue;
                if (list == null) {
                    list = new ArrayList<E>(rightSet.size());
                }
                list.add(left);
            }
            return list == null ? Collections.emptyList() : list;
        }
        return CollectionUtils.intersection(leftIterable.iterator(), rightIterable.iterator());
    }

    public static <E, T> Collection<T> intersection(Iterable<? extends E> leftIterable, Iterable<? extends E> rightIterable, Comparator<? super E> comparator, BiFunction<? super E, ? super E, ? extends T> combiner) {
        if (CollectionUtils.isEmpty(leftIterable) || CollectionUtils.isEmpty(rightIterable)) {
            return Collections.emptyList();
        }
        return CollectionUtils.intersection(leftIterable.iterator(), rightIterable.iterator(), comparator, combiner);
    }

    public static <E> Collection<E> intersection(Iterator<? extends E> leftIterator, Iterator<? extends E> rightIterator) {
        return CollectionUtils.intersection(leftIterator, rightIterator, (o1, o2) -> ObjectUtils.equals(o1, o2) ? 0 : 1, (? super E o1, ? super E o2) -> o1);
    }

    public static <E, T> Collection<T> intersection(Iterator<? extends E> leftIterator, Iterator<? extends E> rightIterator, Comparator<? super E> comparator, BiFunction<? super E, ? super E, ? extends T> combiner) {
        Assert.requiredArgument(comparator != null, "comparator");
        Assert.requiredArgument(combiner != null, "combiner");
        if (CollectionUtils.isEmpty(leftIterator) || CollectionUtils.isEmpty(rightIterator)) {
            return Collections.emptyList();
        }
        ArrayList rightList = new ArrayList();
        rightIterator.forEachRemaining(rightList::add);
        ArrayList<T> list = null;
        block0: while (leftIterator.hasNext()) {
            E left = leftIterator.next();
            Iterator rightListIterator = rightList.iterator();
            while (rightListIterator.hasNext()) {
                Object right = rightListIterator.next();
                if (comparator.compare(left, right) != 0) continue;
                if (list == null) {
                    list = new ArrayList<T>(rightList.size());
                }
                T element = combiner.apply(left, right);
                list.add(element);
                rightListIterator.remove();
                continue block0;
            }
        }
        return list == null ? Collections.emptyList() : list;
    }

    public static <E> boolean isAll(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        if (iterable == null) {
            return true;
        }
        return CollectionUtils.isAll(iterable.iterator(), predicate);
    }

    public static <E> boolean isAll(Iterator<? extends E> iterator, Predicate<? super E> predicate) {
        Assert.requiredArgument(predicate != null, "predicate");
        if (iterator == null) {
            return true;
        }
        while (iterator.hasNext()) {
            E element = iterator.next();
            if (predicate.test(element)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean isAny(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        if (iterable == null) {
            return false;
        }
        return CollectionUtils.isAny(iterable.iterator(), predicate);
    }

    public static <E> boolean isAny(Iterator<? extends E> iterator, Predicate<? super E> predicate) {
        Assert.requiredArgument(predicate != null, "predicate");
        if (iterator == null) {
            return false;
        }
        while (iterator.hasNext()) {
            E element = iterator.next();
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        Iterator<?> iterator = iterable.iterator();
        return CollectionUtils.isEmpty(iterator);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return iterator == null || !iterator.hasNext();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isUnmodifiable(Object collection) {
        if (collection == null) {
            return false;
        }
        if (collection instanceof Collection || collection instanceof Map) {
            return collection.getClass().getSimpleName().startsWith("Unmodifiable");
        }
        return false;
    }

    public static <S, T> Iterator<T> iterator(Iterator<? extends S> iterator, Function<? super S, ? extends Iterator<T>> converter) {
        Assert.requiredArgument(converter != null, "converter");
        if (iterator == null) {
            return Collections.emptyIterator();
        }
        return new IterationIterator(iterator, converter);
    }

    public static <E> List<E> list(Iterator<? extends E> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return Collections.emptyList();
        }
        return Collections.list(CollectionUtils.toEnumeration(iterator));
    }

    public static void mergeArrayIntoCollection(Object array, Collection collection) {
        Object[] arr;
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        for (Object elem : arr = ObjectUtils.toObjectArray(array)) {
            collection.add(elem);
        }
    }

    public static void mergePropertiesIntoMap(Properties props, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = props.getProperty(key);
                if (value == null) {
                    value = props.get(key);
                }
                map.put(key, value);
            }
        }
    }

    public static <E> List<E> reversal(Collection<E> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        Object[] values = collection.toArray();
        values = ArrayUtils.reversal(values);
        return Arrays.asList(values);
    }

    public static int size(Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static int size(Map<?, ?> map) {
        return map == null ? 0 : map.size();
    }

    public static <K, V> Map<K, V> sort(Map<K, V> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        Object[] keys = source.keySet().toArray();
        Arrays.sort(keys);
        LinkedHashMap<Object, V> map = new LinkedHashMap<Object, V>(source.size());
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            map.put(key, source.get(key));
        }
        return map;
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] array) {
        ArrayList<E> elements = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            elements.add(enumeration.nextElement());
        }
        return elements.toArray(array);
    }

    public static <E> Enumeration<E> toEnumeration(final Iterator<? extends E> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return Collections.emptyEnumeration();
        }
        return new Enumeration<E>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public E nextElement() {
                return iterator.next();
            }
        };
    }

    public static <E> Iterator<E> toIterator(Enumeration<? extends E> enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.emptyIterator();
        }
        return new EnumerationIterator<E>(enumeration);
    }

    public static <K, V> MultiValueMap<K, V> toMultiValueMap(Map<K, List<V>> map) {
        return new MultiValueMapWrapper<K, V>(map);
    }

    public static <E> Set<E> toSet(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptySet();
        }
        LinkedHashSet<E> sets = new LinkedHashSet<E>();
        while (iterator.hasNext()) {
            sets.add(iterator.next());
        }
        return sets;
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<K, V> map) {
        if (CollectionUtils.isUnmodifiable(map)) {
            return map;
        }
        if (map instanceof NavigableMap) {
            return Collections.unmodifiableNavigableMap((NavigableMap)map);
        }
        if (map instanceof SortedMap) {
            return Collections.unmodifiableSortedMap((SortedMap)map);
        }
        if (map instanceof MultiValueMap) {
            return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)map);
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> MultiValueMap<K, V> unmodifiableMultiValueMap(Map<? extends K, ? extends List<V>> map) {
        Assert.notNull(map, "'map' must not be null");
        LinkedHashMap<K, List<V>> result = new LinkedHashMap<K, List<V>>(map.size());
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            List<V> values = Collections.unmodifiableList(entry.getValue());
            result.put(entry.getKey(), values);
        }
        Map unmodifiableMap = Collections.unmodifiableMap(result);
        return CollectionUtils.toMultiValueMap(unmodifiableMap);
    }

    public static <E> Set<E> unmodifiableSet(Set<E> set) {
        if (CollectionUtils.isUnmodifiable(set)) {
            return set;
        }
        if (set instanceof NavigableSet) {
            return Collections.unmodifiableNavigableSet((NavigableSet)set);
        }
        if (set instanceof SortedSet) {
            return Collections.unmodifiableSortedSet((SortedSet)set);
        }
        return Collections.unmodifiableSet(set);
    }

    public static <E> boolean unorderedEquals(Collection<? extends E> leftColllection, Collection<? extends E> rightCollection) {
        if (CollectionUtils.isEmpty(leftColllection)) {
            return CollectionUtils.isEmpty(rightCollection);
        }
        if (CollectionUtils.isEmpty(rightCollection)) {
            return CollectionUtils.isEmpty(leftColllection);
        }
        return leftColllection.size() == rightCollection.size() && CollectionUtils.intersection(leftColllection, rightCollection).size() == leftColllection.size();
    }

    private static final class PreviousIterator<E>
    implements Iterator<E> {
        private final ListIterator<E> listIterator;

        public PreviousIterator(ListIterator<E> listIterator) {
            this.listIterator = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasPrevious();
        }

        @Override
        public E next() {
            return this.listIterator.previous();
        }

        @Override
        public void remove() {
            this.listIterator.remove();
        }
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private Enumeration<? extends E> enumeration;

        public EnumerationIterator(Enumeration<? extends E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }
    }
}

