/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.Processor;
import java.util.Iterator;
import java.util.Objects;

@FunctionalInterface
public interface ConsumeProcessor<S, E extends Throwable> {
    public void process(S var1) throws E;

    default public ConsumeProcessor<S, E> compose(ConsumeProcessor<? super S, ? extends E> before) {
        Objects.requireNonNull(before);
        return t -> {
            before.process(t);
            this.process(t);
        };
    }

    default public ConsumeProcessor<S, E> andThen(ConsumeProcessor<? super S, ? extends E> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.process(t);
            after.process(t);
        };
    }

    default public Processor<S, Void, E> toProcessor() {
        return new Processor<S, Void, E>(){

            @Override
            public Void process(S source) throws Throwable {
                ConsumeProcessor.this.process(source);
                return null;
            }
        };
    }

    default public void processAll(Iterator<? extends S> sourceIterator) throws E {
        Assert.requiredArgument(sourceIterator != null, "sourceIterator");
        if (sourceIterator.hasNext()) {
            S source = sourceIterator.next();
            try {
                this.process(source);
            }
            finally {
                this.processAll(sourceIterator);
            }
        }
    }

    default public void processAll(Iterable<? extends S> sources) throws E {
        Assert.requiredArgument(sources != null, "sources");
        this.processAll(sources.iterator());
    }

    public static <A, X extends Throwable> void consumeAll(Iterator<? extends A> sourceIterator, ConsumeProcessor<? super A, ? extends X> processor) throws X {
        Assert.requiredArgument(processor != null, "processor");
        processor.processAll(sourceIterator);
    }

    public static <A, X extends Throwable> void consumeAll(Iterable<? extends A> sources, ConsumeProcessor<? super A, ? extends X> processor) throws X {
        Assert.requiredArgument(processor != null, "processor");
        processor.processAll(sources);
    }
}

