/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Closeable;
import io.basc.framework.util.CloseableIterator;
import io.basc.framework.util.ConvertibleCursor;
import io.basc.framework.util.ConvertibleIterator;
import io.basc.framework.util.FilterableCursor;
import io.basc.framework.util.RunnableProcessor;
import io.basc.framework.util.StandardCursor;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Cursor<E>
extends CloseableIterator<E>,
Closeable<RuntimeException> {
    public BigInteger getPosition();

    @Override
    public Cursor<E> onClose(RunnableProcessor<? extends RuntimeException> var1);

    @Override
    default public Cursor<E> limit(long start) {
        return this.limit(BigInteger.valueOf(start), null);
    }

    @Override
    default public Cursor<E> limit(long start, long count) {
        return this.limit(BigInteger.valueOf(start), BigInteger.valueOf(count));
    }

    @Override
    default public <U> Cursor<U> flatConvert(Function<? super Stream<E>, ? extends Stream<U>> mapper) {
        return Cursor.of(mapper.apply(this.stream()));
    }

    @Override
    default public <U> Cursor<U> convert(Function<? super E, ? extends U> converter) {
        return new ConvertibleCursor<E, U>(this, converter, this.getPosition(), () -> this.close());
    }

    @Override
    default public <T> Cursor<T> map(Function<? super E, ? extends T> mapper) {
        StandardCursor cursor = new StandardCursor(new ConvertibleIterator<E, T>(this, mapper), this.getPosition());
        return cursor.onClose(() -> this.close());
    }

    @Override
    default public Cursor<E> filter(Predicate<? super E> predicate) {
        return new FilterableCursor<E>(this, predicate, () -> this.close());
    }

    @Override
    default public Cursor<E> limit(BigInteger start, BigInteger limit) {
        return new FilterableCursor(this, start, limit, () -> this.close());
    }

    @Override
    default public Cursor<E> limit(Predicate<? super E> start, Predicate<? super E> end) {
        return new FilterableCursor<E>(this, start, end, () -> this.close());
    }

    @Override
    default public void forEachRemaining(Consumer<? super E> action) {
        try {
            CloseableIterator.super.forEachRemaining(action);
        }
        finally {
            this.close();
        }
    }

    public static <T> Cursor<T> empty() {
        return Cursor.of(Collections.emptyIterator());
    }

    public static <T> Cursor<T> of(Iterator<? extends T> iterator) {
        if (iterator == null) {
            return Cursor.empty();
        }
        if (iterator instanceof Cursor) {
            return (Cursor)iterator;
        }
        if (iterator instanceof CloseableIterator) {
            return new StandardCursor((CloseableIterator)iterator);
        }
        return new StandardCursor(iterator);
    }

    public static <T> Cursor<T> of(Stream<? extends T> stream) {
        if (stream == null) {
            return Cursor.empty();
        }
        Cursor cursor = Cursor.of(stream.iterator());
        return cursor.onClose(() -> stream.close());
    }

    public static <T> Cursor<T> of(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return Cursor.empty();
        }
        Iterator<? extends T> iterator = iterable instanceof List ? ((List)iterable).listIterator() : iterable.iterator();
        return new StandardCursor(iterator);
    }

    @SafeVarargs
    public static <T> Cursor<T> of(T ... values) {
        if (values == null) {
            return Cursor.empty();
        }
        return Cursor.of(Arrays.asList(values));
    }
}

