/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.AbstractCursor;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.ReversibleIterator;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Cursors<E>
extends AbstractCursor<E, Cursors<E>> {
    private BigInteger position = BigInteger.ZERO;
    private final ReversibleIterator<? extends Cursor<E>> sources;
    private Cursor<E> currentCursor;

    public Cursors(Iterator<? extends Cursor<E>> sources) {
        Assert.requiredArgument(sources != null, "sources");
        this.sources = Cursor.of(sources);
    }

    public Cursors(List<? extends Cursor<E>> sources) {
        Assert.requiredArgument(sources != null, "sources");
        this.sources = Cursor.of(sources);
    }

    @Override
    public BigInteger getPosition() {
        return this.position;
    }

    @Override
    public boolean hasNext() {
        if (this.currentCursor == null || !this.currentCursor.hasNext()) {
            while (this.sources.hasNext()) {
                this.currentCursor = (Cursor)this.sources.next();
                this.position = this.position.add(this.currentCursor.getPosition());
                super.onClose(() -> this.currentCursor.close());
                if (!this.currentCursor.hasNext()) continue;
            }
        }
        return this.currentCursor != null && this.currentCursor.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Object e = this.currentCursor.next();
            return e;
        }
        finally {
            this.position = this.position.add(BigInteger.ONE);
        }
    }

    @Override
    public boolean hasPrevious() {
        if (this.position.compareTo(BigInteger.ZERO) <= 0) {
            return false;
        }
        if (this.currentCursor == null || !this.currentCursor.hasPrevious()) {
            while (this.sources.hasPrevious()) {
                this.currentCursor = (Cursor)this.sources.previous();
                this.position = this.position.subtract(this.currentCursor.getPosition());
                super.onClose(() -> this.currentCursor.close());
                if (!this.currentCursor.hasPrevious()) continue;
            }
        }
        return this.currentCursor != null && this.currentCursor.hasPrevious();
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        try {
            Object e = this.currentCursor.previous();
            return e;
        }
        finally {
            this.position = this.position.subtract(BigInteger.ONE);
        }
    }

    @Override
    public void remove() {
        if (this.currentCursor != null) {
            this.currentCursor.remove();
        }
    }
}

