/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.ConsumeProcessor;

public class DecoratedConsumeProcessor<S, E extends Throwable>
implements ConsumeProcessor<S, E> {
    private DecoratedConsumeProcessor<S, E> beforeProcessor;
    private DecoratedConsumeProcessor<S, E> afterProcessor;
    private final ConsumeProcessor<? super S, ? extends E> processor;

    public DecoratedConsumeProcessor() {
        this(null);
    }

    public DecoratedConsumeProcessor(@Nullable ConsumeProcessor<? super S, ? extends E> processor) {
        this.processor = processor;
    }

    @Override
    public void process(S source) throws E {
        if (this.beforeProcessor != null) {
            this.beforeProcessor.process(source);
        }
        try {
            if (this.processor != null) {
                this.processor.process(source);
            }
        }
        finally {
            if (this.afterProcessor != null) {
                this.afterProcessor.process(source);
            }
        }
    }

    public DecoratedConsumeProcessor<S, E> before(ConsumeProcessor<? super S, ? extends E> processor) {
        this.beforeProcessor = this.beforeProcessor == null ? new DecoratedConsumeProcessor<S, E>(processor) : this.beforeProcessor.before(processor);
        return this;
    }

    public DecoratedConsumeProcessor<S, E> after(ConsumeProcessor<? super S, ? extends E> processor) {
        if (this.afterProcessor == null) {
            this.afterProcessor = new DecoratedConsumeProcessor<S, E>(processor);
        } else {
            this.beforeProcessor = this.afterProcessor.before(processor);
        }
        return this;
    }
}

