/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Optional;
import io.basc.framework.util.OptionalDouble;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;

public final class DefaultOptionalDouble
implements OptionalDouble,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final OptionalDouble EMPTY = new DefaultOptionalDouble(false, 0.0);
    private final boolean present;
    private final double value;

    public DefaultOptionalDouble(double value) {
        this(true, value);
    }

    public DefaultOptionalDouble(boolean present, double value) {
        this.present = present;
        this.value = value;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public Double get() {
        return this.getAsDouble();
    }

    @Override
    public double getAsDouble() {
        if (this.present) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    @Override
    public OptionalDouble filter(DoublePredicate predicate) {
        if (this.isPresent()) {
            return predicate.test(this.value) ? this : EMPTY;
        }
        return this;
    }

    @Override
    public <U> Optional<U> map(DoubleFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.present) {
            return Optional.of(mapper.apply(this.value));
        }
        return Optional.empty();
    }

    @Override
    public <U> Optional<U> flatMap(DoubleFunction<Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.present) {
            return Objects.requireNonNull(mapper.apply(this.value));
        }
        return Optional.empty();
    }

    @Override
    public OptionalDouble filter(Predicate<? super Double> predicate) {
        if (this.isPresent()) {
            return predicate.test((Double)this.value) ? this : EMPTY;
        }
        return this;
    }

    public String toString() {
        return this.present ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }
}

