/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Optional;
import io.basc.framework.util.OptionalInt;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public final class DefaultOptionalInt
implements OptionalInt,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final OptionalInt EMPTY = new DefaultOptionalInt(false, 0);
    private final boolean present;
    private final int value;

    public DefaultOptionalInt(int value) {
        this(true, value);
    }

    public DefaultOptionalInt(boolean present, int value) {
        this.present = present;
        this.value = value;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public Integer get() {
        return this.getAsInt();
    }

    @Override
    public int getAsInt() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    @Override
    public OptionalInt filter(IntPredicate predicate) {
        if (this.isPresent()) {
            return predicate.test(this.value) ? this : EMPTY;
        }
        return this;
    }

    @Override
    public <U> Optional<U> map(IntFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.present) {
            return Optional.of(mapper.apply(this.value));
        }
        return Optional.empty();
    }

    @Override
    public <U> Optional<U> flatMap(IntFunction<Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.present) {
            return Objects.requireNonNull(mapper.apply(this.value));
        }
        return Optional.empty();
    }

    @Override
    public OptionalInt filter(Predicate<? super Integer> predicate) {
        if (this.isPresent()) {
            return predicate.test((Integer)this.value) ? this : EMPTY;
        }
        return this;
    }

    public String toString() {
        return this.present ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }
}

