/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.lang.Nullable;
import io.basc.framework.util.AbstractCursor;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ReversibleIterator;
import io.basc.framework.util.RunnableProcessor;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class FilterableCursor<E>
extends AbstractCursor<E, FilterableCursor<E>> {
    private final ReversibleIterator<? extends E> iterator;
    private final Predicate<? super E> startPredicate;
    private final Predicate<? super E> endPredicate;
    private final Predicate<? super E> predicate;
    private boolean hasStart = false;
    private boolean hasEnd = false;
    private Supplier<E> current;
    private BigInteger start;
    private BigInteger position;
    private final BigInteger count;

    public FilterableCursor(ReversibleIterator<? extends E> iterator, BigInteger start, @Nullable BigInteger count, @Nullable RunnableProcessor<? extends RuntimeException> closeProcessor) {
        this(iterator, start, count, null, null, null, closeProcessor);
    }

    public FilterableCursor(ReversibleIterator<? extends E> iterator, @Nullable Predicate<? super E> predicate, @Nullable RunnableProcessor<? extends RuntimeException> closeProcessor) {
        this(iterator, BigInteger.ZERO, null, predicate, null, null, closeProcessor);
    }

    public FilterableCursor(ReversibleIterator<? extends E> iterator, @Nullable Predicate<? super E> startPredicate, @Nullable Predicate<? super E> endPredicate, @Nullable RunnableProcessor<? extends RuntimeException> closeProcessor) {
        this(iterator, BigInteger.ZERO, null, null, startPredicate, endPredicate, closeProcessor);
    }

    public FilterableCursor(ReversibleIterator<? extends E> iterator, BigInteger start, @Nullable BigInteger count, @Nullable Predicate<? super E> predicate, @Nullable Predicate<? super E> startPredicate, @Nullable Predicate<? super E> endPredicate, @Nullable RunnableProcessor<? extends RuntimeException> closeProcessor) {
        super(closeProcessor);
        Assert.requiredArgument(iterator != null, "iterator");
        Assert.requiredArgument(start != null && start.compareTo(BigInteger.ZERO) >= 0, "start");
        Assert.requiredArgument(count == null || count.compareTo(BigInteger.ZERO) >= 0, "count");
        this.iterator = iterator;
        this.startPredicate = startPredicate;
        this.endPredicate = endPredicate;
        this.predicate = predicate;
        this.start = start;
        this.count = count;
    }

    private void initPosition() {
        if (this.position == null) {
            BigInteger i = BigInteger.ZERO;
            while (this.start.compareTo(i) > 0 && this.iterator.hasNext()) {
                Object e = this.iterator.next();
                if (this.hasStart || !this.hasEnd || this.predicate == null || this.predicate.test(e)) {
                    if (!this.hasStart && this.startPredicate != null && this.startPredicate.test(e)) {
                        this.hasStart = true;
                    }
                    if (!this.hasEnd && this.endPredicate != null && this.endPredicate.test(e)) {
                        this.hasEnd = true;
                    }
                }
                i = i.add(BigInteger.ONE);
            }
            this.position = BigInteger.ZERO;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        if (this.hasEnd) {
            return false;
        }
        this.initPosition();
        if (this.count != null && this.position.compareTo(this.count) >= 0) {
            return false;
        }
        if (this.startPredicate == null && this.endPredicate == null && this.predicate == null) {
            return this.iterator.hasNext();
        }
        while (this.iterator.hasNext()) {
            if (this.predicate == null && this.hasStart) {
                return true;
            }
            Object e = this.iterator.next();
            if (this.predicate != null && !this.predicate.test(e)) continue;
            if (this.startPredicate != null && this.startPredicate.test(e)) {
                this.hasStart = true;
            }
            if (this.endPredicate != null && this.endPredicate.test(e)) {
                this.hasEnd = true;
                return false;
            }
            this.current = () -> e;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            E e;
            if (this.predicate == null && this.startPredicate == null && this.endPredicate == null) {
                Object e2 = this.iterator.next();
                return e2;
            }
            try {
                e = this.current.get();
                this.current = null;
            }
            catch (Throwable throwable) {
                this.current = null;
                throw throwable;
            }
            return e;
        }
        finally {
            this.position = this.position.add(BigInteger.ONE);
        }
    }

    @Override
    public boolean hasPrevious() {
        this.initPosition();
        if (this.position.compareTo(BigInteger.ZERO) <= 0) {
            return false;
        }
        return this.iterator.hasPrevious();
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        try {
            Object e = this.iterator.previous();
            return e;
        }
        finally {
            this.position = this.position.subtract(BigInteger.ONE);
        }
    }

    @Override
    public BigInteger getPosition() {
        return this.position == null ? BigInteger.ZERO : this.position;
    }
}

