/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Assert;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Inheriter;
import io.basc.framework.util.Processor;
import io.basc.framework.util.Source;
import io.basc.framework.util.Wrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class InheriterDecorator<A, B>
implements Inheriter<A, B> {
    private boolean nestedExecutor = true;

    public boolean isNestedExecutor() {
        return this.nestedExecutor;
    }

    public void setNestedExecutor(boolean nestedExecutor) {
        this.nestedExecutor = nestedExecutor;
    }

    public final <V> Callable<V> decorateCallable(Callable<? extends V> callable) {
        Assert.requiredArgument(callable != null, "callable");
        return this.decorateSource(callable::call)::get;
    }

    public final <S, E extends Throwable> ConsumeProcessor<S, E> decorateConsumeProcessor(ConsumeProcessor<? super S, ? extends E> consumeProcessor) {
        Assert.requiredArgument(consumeProcessor != null, "consumeProcessor");
        Processor processor = this.decorateProcessor(s -> {
            consumeProcessor.process(s);
            return null;
        });
        return s -> processor.process(s);
    }

    public final <T> Consumer<T> decorateConsumer(Consumer<? super T> consumer) {
        Assert.requiredArgument(consumer != null, "consumer");
        ConsumeProcessor consumeProcessor = this.decorateConsumeProcessor(consumer::accept);
        return s -> consumeProcessor.process(s);
    }

    public final <T, R> Function<T, R> decorateFunction(Function<? super T, ? extends R> function) {
        Assert.requiredArgument(function != null, "function");
        Processor processor = this.decorateProcessor(function::apply);
        return s -> processor.process(s);
    }

    public <S, T, E extends Throwable> Processor<S, T, E> decorateProcessor(Processor<? super S, ? extends T, ? extends E> processor) {
        Assert.requiredArgument(processor != null, "processor");
        return new InheritableProcessor<S, T, E>(processor);
    }

    public final Runnable decorateRunnable(Runnable runnable) {
        Assert.requiredArgument(runnable != null, "runnable");
        Source source = this.decorateSource(() -> {
            runnable.run();
            return null;
        });
        return () -> source.get();
    }

    public <T, E extends Throwable> Source<T, E> decorateSource(Source<? extends T, ? extends E> source) {
        Assert.requiredArgument(source != null, "source");
        return new InheritableSource<T, E>(source);
    }

    public final <T> Supplier<T> decorateSupplier(Supplier<? extends T> supplier) {
        Assert.requiredArgument(supplier != null, "supplier");
        Source source = this.decorateSource(supplier::get);
        return () -> source.get();
    }

    public final Executor decorateExecutor(Executor executor) {
        Assert.requiredArgument(executor != null, "executor");
        if (executor instanceof InhertableExecutor) {
            InhertableExecutor inhertableExecutor = (InhertableExecutor)executor;
            if (this.isNestedExecutor() ? this == inhertableExecutor.inheriterDecorator : inhertableExecutor.isNested(this)) {
                return executor;
            }
        }
        return new InhertableExecutor(this, executor);
    }

    public final ExecutorService decorateExecutorService(ExecutorService executorService) {
        Assert.requiredArgument(executorService != null, "executorService");
        if (executorService instanceof InhertableExecutor) {
            InhertableExecutor inhertableExecutor = (InhertableExecutor)((Object)executorService);
            if (this.isNestedExecutor() ? this == inhertableExecutor.inheriterDecorator : inhertableExecutor.isNested(this)) {
                return executorService;
            }
        }
        return new InheritableExecutorService(this, executorService);
    }

    public final ScheduledExecutorService decorateScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        Assert.requiredArgument(scheduledExecutorService != null, "scheduledExecutorService");
        if (scheduledExecutorService instanceof InhertableExecutor) {
            InhertableExecutor inhertableExecutor = (InhertableExecutor)((Object)scheduledExecutorService);
            if (this.isNestedExecutor() ? this == inhertableExecutor.inheriterDecorator : inhertableExecutor.isNested(this)) {
                return scheduledExecutorService;
            }
        }
        return new InheritableScheduledExecutorService(this, scheduledExecutorService);
    }

    private static class InheritableScheduledExecutorService<X, Y, W extends ScheduledExecutorService>
    extends InheritableExecutorService<X, Y, W>
    implements ScheduledExecutorService {
        public InheritableScheduledExecutorService(InheriterDecorator<X, Y> inheriterDecorator, W wrappedTarget) {
            super(inheriterDecorator, wrappedTarget);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return ((ScheduledExecutorService)this.wrappedTarget).schedule(this.inheriterDecorator.decorateRunnable(command), delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return ((ScheduledExecutorService)this.wrappedTarget).schedule(this.inheriterDecorator.decorateCallable(callable), delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return ((ScheduledExecutorService)this.wrappedTarget).scheduleAtFixedRate(this.inheriterDecorator.decorateRunnable(command), initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.scheduleWithFixedDelay(this.inheriterDecorator.decorateRunnable(command), initialDelay, delay, unit);
        }
    }

    private static class InheritableExecutorService<X, Y, W extends ExecutorService>
    extends InhertableExecutor<X, Y, W>
    implements ExecutorService {
        public InheritableExecutorService(InheriterDecorator<X, Y> inheriterDecorator, W wrappedTarget) {
            super(inheriterDecorator, wrappedTarget);
        }

        @Override
        public void shutdown() {
            ((ExecutorService)this.wrappedTarget).shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return ((ExecutorService)this.wrappedTarget).shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return ((ExecutorService)this.wrappedTarget).isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return ((ExecutorService)this.wrappedTarget).isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return ((ExecutorService)this.wrappedTarget).awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return ((ExecutorService)this.wrappedTarget).submit(this.inheriterDecorator.decorateCallable(task));
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return ((ExecutorService)this.wrappedTarget).submit(this.inheriterDecorator.decorateRunnable(task), result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return ((ExecutorService)this.wrappedTarget).submit(this.inheriterDecorator.decorateRunnable(task));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return ((ExecutorService)this.wrappedTarget).invokeAll(CollectionUtils.isEmpty(tasks) ? Collections.emptyList() : (Collection)tasks.stream().map(e -> this.inheriterDecorator.decorateCallable(e)).collect(Collectors.toList()));
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return ((ExecutorService)this.wrappedTarget).invokeAll(CollectionUtils.isEmpty(tasks) ? Collections.emptyList() : (Collection)tasks.stream().map(e -> this.inheriterDecorator.decorateCallable(e)).collect(Collectors.toList()), timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return ((ExecutorService)this.wrappedTarget).invokeAny(CollectionUtils.isEmpty(tasks) ? Collections.emptyList() : (Collection)tasks.stream().map(e -> this.inheriterDecorator.decorateCallable(e)).collect(Collectors.toList()));
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return ((ExecutorService)this.wrappedTarget).invokeAny(CollectionUtils.isEmpty(tasks) ? Collections.emptyList() : (Collection)tasks.stream().map(e -> this.inheriterDecorator.decorateCallable(e)).collect(Collectors.toList()), timeout, unit);
        }
    }

    private static class InhertableExecutor<X, Y, W extends Executor>
    extends Wrapper<W>
    implements Executor {
        protected final InheriterDecorator<X, Y> inheriterDecorator;

        public InhertableExecutor(InheriterDecorator<X, Y> inheriterDecorator, W wrappedTarget) {
            super(wrappedTarget);
            this.inheriterDecorator = inheriterDecorator;
        }

        public boolean isNested(InheriterDecorator<?, ?> inheriterDecorator) {
            if (this.inheriterDecorator == inheriterDecorator) {
                return true;
            }
            if (this.wrappedTarget instanceof InhertableExecutor) {
                return ((InhertableExecutor)this.wrappedTarget).isNested(inheriterDecorator);
            }
            return false;
        }

        @Override
        public void execute(Runnable command) {
            ((Executor)this.wrappedTarget).execute(this.inheriterDecorator.decorateRunnable(command));
        }
    }

    private final class InheritableSource<T, E extends Throwable>
    implements Source<T, E> {
        private final A capture;
        private final Source<? extends T, ? extends E> source;

        InheritableSource(Source<? extends T, ? extends E> source) {
            this.capture = InheriterDecorator.this.capture();
            this.source = source;
        }

        @Override
        public T get() throws E {
            Object backup = InheriterDecorator.this.replay(this.capture);
            try {
                T t = this.source.get();
                return t;
            }
            finally {
                InheriterDecorator.this.restore(backup);
            }
        }
    }

    private final class InheritableProcessor<S, T, E extends Throwable>
    implements Processor<S, T, E> {
        private A capture;
        private final Processor<? super S, ? extends T, ? extends E> processor;

        InheritableProcessor(Processor<? super S, ? extends T, ? extends E> processor) {
            this.capture = InheriterDecorator.this.capture();
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T process(S source) throws E {
            Object backup = InheriterDecorator.this.replay(this.capture);
            try {
                T t = this.processor.process(source);
                return t;
            }
            finally {
                InheriterDecorator.this.restore(backup);
            }
        }
    }
}

