/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.Processor;
import java.util.Objects;

public interface IntConsumerProcessor<E extends Throwable> {
    public void process(int var1) throws E;

    default public IntConsumerProcessor<E> andThen(IntConsumerProcessor<? extends E> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.process(t);
            after.process(t);
        };
    }

    default public Processor<Integer, Void, E> toProcessor() {
        return new Processor<Integer, Void, E>(){

            @Override
            public Void process(Integer source) throws Throwable {
                IntConsumerProcessor.this.process(source);
                return null;
            }
        };
    }

    default public IntConsumerProcessor<E> beforeNesting(IntConsumerProcessor<E> processor) {
        if (processor == null) {
            return this;
        }
        return t -> {
            try {
                this.process(t);
            }
            finally {
                processor.process(t);
            }
        };
    }

    default public IntConsumerProcessor<E> afterNesting(IntConsumerProcessor<E> processor) {
        if (processor == null) {
            return this;
        }
        return t -> {
            try {
                processor.process(t);
            }
            finally {
                this.process(t);
            }
        };
    }
}

