/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.core.type.AnnotationMetadata;
import io.basc.framework.lang.RequiredJavaVersion;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.Version;
import io.basc.framework.value.Value;
import java.util.Map;

public class JavaVersion
extends Version {
    private static final long serialVersionUID = 1L;
    public static final JavaVersion INSTANCE;

    JavaVersion(Value[] fragments, String dividers) {
        super(fragments, dividers);
    }

    public int getMasterVersion() {
        return this.getFragments()[1].getAsNumber().intValue();
    }

    public boolean isJava5() {
        return this.getMasterVersion() == 5;
    }

    public boolean isJava6() {
        return this.getMasterVersion() == 6;
    }

    public boolean isJava7() {
        return this.getMasterVersion() == 7;
    }

    public boolean isJava8() {
        return this.getMasterVersion() == 8;
    }

    public boolean isSupported(int version) {
        return version >= this.getMasterVersion();
    }

    public static boolean isSupported(AnnotationMetadata annotationMetadata) {
        int version;
        Map<String, Object> map = annotationMetadata.getAnnotationAttributes(RequiredJavaVersion.class.getName());
        return CollectionUtils.isEmpty(map) || INSTANCE.isSupported(version = ((Integer)map.get("value")).intValue());
    }

    public static boolean isSupported(Class<?> clazz) {
        RequiredJavaVersion requiredJavaVersion = clazz.getAnnotation(RequiredJavaVersion.class);
        if (requiredJavaVersion != null && !INSTANCE.isSupported(requiredJavaVersion.value())) {
            return false;
        }
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            if (JavaVersion.isSupported(interfaceClass)) continue;
            return false;
        }
        return true;
    }

    static {
        Value fragment;
        Version version = new Version(System.getProperty("java.version"));
        if (version.length() > 1 && (fragment = version.get(0)).isNumber() && fragment.getAsInt() > 1) {
            Value[] fragments = new Value[version.length() + 1];
            fragments[0] = Value.of((Object)1);
            System.arraycopy(version.getFragments(), 0, fragments, 1, version.length());
            version = new Version(fragments, version.getDividers());
        }
        INSTANCE = new JavaVersion(version.getFragments(), version.getDividers());
    }
}

