/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util;

import io.basc.framework.util.AbstractMultiValueMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LinkedMultiValueMap<K, V>
extends AbstractMultiValueMap<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    private final Map<K, List<V>> targetMap;

    public LinkedMultiValueMap() {
        this.targetMap = new LinkedHashMap<K, List<V>>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, List<V>> eldest) {
                return LinkedMultiValueMap.this.overrideRemoveEldestEntry(eldest);
            }
        };
    }

    public LinkedMultiValueMap(int initialCapacity) {
        this.targetMap = new LinkedHashMap<K, List<V>>(initialCapacity){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, List<V>> eldest) {
                return LinkedMultiValueMap.this.overrideRemoveEldestEntry(eldest);
            }
        };
    }

    public LinkedMultiValueMap(int initialCapacity, float loadFactor) {
        this.targetMap = new LinkedHashMap<K, List<V>>(initialCapacity, loadFactor){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, List<V>> eldest) {
                return LinkedMultiValueMap.this.overrideRemoveEldestEntry(eldest);
            }
        };
    }

    public LinkedMultiValueMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        this.targetMap = new LinkedHashMap<K, List<V>>(initialCapacity, loadFactor, accessOrder){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, List<V>> eldest) {
                return LinkedMultiValueMap.this.overrideRemoveEldestEntry(eldest);
            }
        };
    }

    protected boolean overrideRemoveEldestEntry(Map.Entry<K, List<V>> eldest) {
        return false;
    }

    public LinkedMultiValueMap(Map<K, List<V>> otherMap) {
        this.targetMap = new LinkedHashMap<K, List<List<V>>>(otherMap);
    }

    @Override
    protected Map<K, List<V>> getTargetMap() {
        return this.targetMap;
    }
}

